/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.state.file.schema.FileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class FileProtoCodec
implements Codec<File> {
    @NonNull
    public File parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public File parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull File data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileSchema.FILE_ID, (Object)data.fileId(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)FileSchema.CONTENTS, (RandomAccessData)data.contents());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)FileSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)FileSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FileSchema.PRE_SYSTEM_DELETE_EXPIRATION_SECOND, (long)data.preSystemDeleteExpirationSecond());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(File data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.FILE_ID, (Object)data.fileId(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.EXPIRATION_SECOND, (long)data.expirationSecond());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileSchema.CONTENTS, (RandomAccessData)data.contents());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)FileSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FileSchema.DELETED, (boolean)data.deleted());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)FileSchema.PRE_SYSTEM_DELETE_EXPIRATION_SECOND, (long)data.preSystemDeleteExpirationSecond());
    }

    public boolean fastEquals(@NonNull File item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private File parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_file_id /* !! */  = null;
        temp_expiration_second = 0L;
        temp_keys /* !! */  = null;
        temp_contents = Bytes.EMPTY;
        temp_memo = "";
        temp_deleted = false;
        temp_pre_system_delete_expiration_second = 0L;
        try {
            block17: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = FileSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl19
                        value /* !! */  = FileID.DEFAULT;
                        ** GOTO lbl32
lbl19:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value /* !! */  = strictMode != false ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl32:
                        // 2 sources

                        temp_file_id /* !! */  = value /* !! */ ;
                        continue block17;
                    }
                    case 16: {
                        temp_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 26: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl42
                        value /* !! */  = KeyList.DEFAULT;
                        ** GOTO lbl55
lbl42:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 /* !! */  = value /* !! */  = strictMode != false ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl55:
                        // 2 sources

                        temp_keys /* !! */  = value /* !! */ ;
                        continue block17;
                    }
                    case 34: {
                        temp_contents = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 42: {
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 48: {
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block17;
                    }
                    case 56: {
                        temp_pre_system_delete_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block17;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new File(temp_file_id /* !! */ , temp_expiration_second, (KeyList)temp_keys /* !! */ , temp_contents, temp_memo, temp_deleted, temp_pre_system_delete_expiration_second);
        }
        catch (EOFException var12_11) {
            // empty catch block
        }
        return new File(temp_file_id /* !! */ , temp_expiration_second, (KeyList)temp_keys /* !! */ , temp_contents, temp_memo, temp_deleted, temp_pre_system_delete_expiration_second);
    }
}

