/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.TokenWipeAccountTransactionBody;
import com.hedera.hapi.node.token.schema.TokenWipeAccountTransactionBodySchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class TokenWipeAccountTransactionBodyJsonCodec
implements JsonCodec<TokenWipeAccountTransactionBody> {
    @NonNull
    public TokenWipeAccountTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        TokenID temp_token = null;
        AccountID temp_account = null;
        long temp_amount = 0L;
        List<Long> temp_serialNumbers = Collections.emptyList();
        block12: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "token": {
                    temp_token = (TokenID)TokenID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block12;
                }
                case "account": {
                    temp_account = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                    continue block12;
                }
                case "amount": {
                    temp_amount = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block12;
                }
                case "serialNumbers": {
                    temp_serialNumbers = kvPair.value().arr().value().stream().map(v -> JsonTools.parseLong((JSONParser.ValueContext)v)).toList();
                    continue block12;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new TokenWipeAccountTransactionBody(temp_token, temp_account, temp_amount, temp_serialNumbers);
    }

    public String toJSON(@NonNull TokenWipeAccountTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.token() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"token", TokenID.JSON, (Object)data.token()));
        }
        if (data.account() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"account", AccountID.JSON, (Object)data.account()));
        }
        if (data.amount() != 0L) {
            fieldLines.add(JsonTools.field((String)"amount", (long)data.amount()));
        }
        if (!data.serialNumbers().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"serialNumbers", (FieldDefinition)TokenWipeAccountTransactionBodySchema.SERIAL_NUMBERS, data.serialNumbers()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

