/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AssessedCustomFee(long amount, @Nullable TokenID tokenId, @Nullable AccountID feeCollectorAccountId, @Nullable List<AccountID> effectivePayerAccountId) {
    public static final Codec<AssessedCustomFee> PROTOBUF = new AssessedCustomFeeProtoCodec();
    public static final JsonCodec<AssessedCustomFee> JSON = new AssessedCustomFeeJsonCodec();
    public static final AssessedCustomFee DEFAULT = AssessedCustomFee.newBuilder().build();

    @Override
    public int hashCode() {
        List<AccountID> list$effectivePayerAccountId;
        int result = 1;
        if (this.amount != AssessedCustomFee.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        if (this.tokenId != null && !this.tokenId.equals(AssessedCustomFee.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(AssessedCustomFee.DEFAULT.feeCollectorAccountId)) {
            result = 31 * result + this.feeCollectorAccountId.hashCode();
        }
        if ((list$effectivePayerAccountId = this.effectivePayerAccountId) != null) {
            for (AccountID o : list$effectivePayerAccountId) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AssessedCustomFee thatObj = (AssessedCustomFee)that;
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.feeCollectorAccountId == null && thatObj.feeCollectorAccountId != null) {
            return false;
        }
        if (this.feeCollectorAccountId != null && !this.feeCollectorAccountId.equals(thatObj.feeCollectorAccountId)) {
            return false;
        }
        if (this.effectivePayerAccountId == null && thatObj.effectivePayerAccountId != null) {
            return false;
        }
        return this.effectivePayerAccountId == null || this.effectivePayerAccountId.equals(thatObj.effectivePayerAccountId);
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasFeeCollectorAccountId() {
        return this.feeCollectorAccountId != null;
    }

    public AccountID feeCollectorAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasFeeCollectorAccountId() ? this.feeCollectorAccountId : defaultValue;
    }

    @NonNull
    public AccountID feeCollectorAccountIdOrThrow() {
        return Objects.requireNonNull(this.feeCollectorAccountId, "Field feeCollectorAccountId is null");
    }

    public void ifFeeCollectorAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasFeeCollectorAccountId()) {
            ifPresent.accept(this.feeCollectorAccountId);
        }
    }

    public boolean hasEffectivePayerAccountId() {
        return this.effectivePayerAccountId != null;
    }

    public List<AccountID> effectivePayerAccountIdOrElse(@NonNull List<AccountID> defaultValue) {
        return this.hasEffectivePayerAccountId() ? this.effectivePayerAccountId : defaultValue;
    }

    @NonNull
    public List<AccountID> effectivePayerAccountIdOrThrow() {
        return Objects.requireNonNull(this.effectivePayerAccountId, "Field effectivePayerAccountId is null");
    }

    public void ifEffectivePayerAccountId(@NonNull Consumer<List<AccountID>> ifPresent) {
        if (this.hasEffectivePayerAccountId()) {
            ifPresent.accept(this.effectivePayerAccountId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long amount = 0L;
        private TokenID tokenId = null;
        private AccountID feeCollectorAccountId = null;
        private List<AccountID> effectivePayerAccountId = Collections.emptyList();

        public Builder() {
        }

        public Builder(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId) {
            this.amount = amount;
            this.tokenId = tokenId;
            this.feeCollectorAccountId = feeCollectorAccountId;
            this.effectivePayerAccountId = effectivePayerAccountId;
        }

        public AssessedCustomFee build() {
            return new AssessedCustomFee(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId);
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder feeCollectorAccountId(AccountID feeCollectorAccountId) {
            this.feeCollectorAccountId = feeCollectorAccountId;
            return this;
        }

        public Builder feeCollectorAccountId(AccountID.Builder builder) {
            this.feeCollectorAccountId = builder.build();
            return this;
        }

        public Builder effectivePayerAccountId(List<AccountID> effectivePayerAccountId) {
            this.effectivePayerAccountId = effectivePayerAccountId;
            return this;
        }

        public Builder effectivePayerAccountId(AccountID ... values) {
            this.effectivePayerAccountId = List.of(values);
            return this;
        }
    }
}

