/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.transaction.codec.FractionalFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.FractionalFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FractionalFee(@Nullable Fraction fractionalAmount, long minimumAmount, long maximumAmount, boolean netOfTransfers) {
    public static final Codec<FractionalFee> PROTOBUF = new FractionalFeeProtoCodec();
    public static final JsonCodec<FractionalFee> JSON = new FractionalFeeJsonCodec();
    public static final FractionalFee DEFAULT = FractionalFee.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fractionalAmount != null && !this.fractionalAmount.equals(FractionalFee.DEFAULT.fractionalAmount)) {
            result = 31 * result + this.fractionalAmount.hashCode();
        }
        if (this.minimumAmount != FractionalFee.DEFAULT.minimumAmount) {
            result = 31 * result + Long.hashCode(this.minimumAmount);
        }
        if (this.maximumAmount != FractionalFee.DEFAULT.maximumAmount) {
            result = 31 * result + Long.hashCode(this.maximumAmount);
        }
        if (this.netOfTransfers != FractionalFee.DEFAULT.netOfTransfers) {
            result = 31 * result + Boolean.hashCode(this.netOfTransfers);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FractionalFee thatObj = (FractionalFee)that;
        if (this.fractionalAmount == null && thatObj.fractionalAmount != null) {
            return false;
        }
        if (this.fractionalAmount != null && !this.fractionalAmount.equals(thatObj.fractionalAmount)) {
            return false;
        }
        if (this.minimumAmount != thatObj.minimumAmount) {
            return false;
        }
        if (this.maximumAmount != thatObj.maximumAmount) {
            return false;
        }
        return this.netOfTransfers == thatObj.netOfTransfers;
    }

    public boolean hasFractionalAmount() {
        return this.fractionalAmount != null;
    }

    public Fraction fractionalAmountOrElse(@NonNull Fraction defaultValue) {
        return this.hasFractionalAmount() ? this.fractionalAmount : defaultValue;
    }

    @NonNull
    public Fraction fractionalAmountOrThrow() {
        return Objects.requireNonNull(this.fractionalAmount, "Field fractionalAmount is null");
    }

    public void ifFractionalAmount(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasFractionalAmount()) {
            ifPresent.accept(this.fractionalAmount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fractionalAmount, this.minimumAmount, this.maximumAmount, this.netOfTransfers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Fraction fractionalAmount = null;
        private long minimumAmount = 0L;
        private long maximumAmount = 0L;
        private boolean netOfTransfers = false;

        public Builder() {
        }

        public Builder(Fraction fractionalAmount, long minimumAmount, long maximumAmount, boolean netOfTransfers) {
            this.fractionalAmount = fractionalAmount;
            this.minimumAmount = minimumAmount;
            this.maximumAmount = maximumAmount;
            this.netOfTransfers = netOfTransfers;
        }

        public FractionalFee build() {
            return new FractionalFee(this.fractionalAmount, this.minimumAmount, this.maximumAmount, this.netOfTransfers);
        }

        public Builder fractionalAmount(Fraction fractionalAmount) {
            this.fractionalAmount = fractionalAmount;
            return this;
        }

        public Builder fractionalAmount(Fraction.Builder builder) {
            this.fractionalAmount = builder.build();
            return this;
        }

        public Builder minimumAmount(long minimumAmount) {
            this.minimumAmount = minimumAmount;
            return this;
        }

        public Builder maximumAmount(long maximumAmount) {
            this.maximumAmount = maximumAmount;
            return this;
        }

        public Builder netOfTransfers(boolean netOfTransfers) {
            this.netOfTransfers = netOfTransfers;
            return this;
        }
    }
}

