/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.consensus.ConsensusCreateTopicTransactionBody;
import com.hedera.hapi.node.consensus.ConsensusDeleteTopicTransactionBody;
import com.hedera.hapi.node.consensus.ConsensusSubmitMessageTransactionBody;
import com.hedera.hapi.node.consensus.ConsensusUpdateTopicTransactionBody;
import com.hedera.hapi.node.contract.ContractCallTransactionBody;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.contract.ContractDeleteTransactionBody;
import com.hedera.hapi.node.contract.ContractUpdateTransactionBody;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.hapi.node.file.FileAppendTransactionBody;
import com.hedera.hapi.node.file.FileCreateTransactionBody;
import com.hedera.hapi.node.file.FileDeleteTransactionBody;
import com.hedera.hapi.node.file.FileUpdateTransactionBody;
import com.hedera.hapi.node.file.SystemDeleteTransactionBody;
import com.hedera.hapi.node.file.SystemUndeleteTransactionBody;
import com.hedera.hapi.node.freeze.FreezeTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleDeleteTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleSignTransactionBody;
import com.hedera.hapi.node.token.CryptoAddLiveHashTransactionBody;
import com.hedera.hapi.node.token.CryptoApproveAllowanceTransactionBody;
import com.hedera.hapi.node.token.CryptoCreateTransactionBody;
import com.hedera.hapi.node.token.CryptoDeleteAllowanceTransactionBody;
import com.hedera.hapi.node.token.CryptoDeleteLiveHashTransactionBody;
import com.hedera.hapi.node.token.CryptoDeleteTransactionBody;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.CryptoUpdateTransactionBody;
import com.hedera.hapi.node.token.TokenAssociateTransactionBody;
import com.hedera.hapi.node.token.TokenBurnTransactionBody;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.token.TokenDeleteTransactionBody;
import com.hedera.hapi.node.token.TokenDissociateTransactionBody;
import com.hedera.hapi.node.token.TokenFeeScheduleUpdateTransactionBody;
import com.hedera.hapi.node.token.TokenFreezeAccountTransactionBody;
import com.hedera.hapi.node.token.TokenGrantKycTransactionBody;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.token.TokenPauseTransactionBody;
import com.hedera.hapi.node.token.TokenRevokeKycTransactionBody;
import com.hedera.hapi.node.token.TokenUnfreezeAccountTransactionBody;
import com.hedera.hapi.node.token.TokenUnpauseTransactionBody;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.token.TokenWipeAccountTransactionBody;
import com.hedera.hapi.node.transaction.NodeStakeUpdateTransactionBody;
import com.hedera.hapi.node.transaction.UncheckedSubmitBody;
import com.hedera.hapi.node.transaction.codec.TransactionBodyJsonCodec;
import com.hedera.hapi.node.transaction.codec.TransactionBodyProtoCodec;
import com.hedera.hapi.node.util.UtilPrngTransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionBody(@Nullable TransactionID transactionID, @Nullable AccountID nodeAccountID, long transactionFee, @Nullable Duration transactionValidDuration, boolean generateRecord, String memo, OneOf<DataOneOfType> data) {
    public static final Codec<TransactionBody> PROTOBUF = new TransactionBodyProtoCodec();
    public static final JsonCodec<TransactionBody> JSON = new TransactionBodyJsonCodec();
    public static final TransactionBody DEFAULT = TransactionBody.newBuilder().build();

    public TransactionBody {
        if (data == null) {
            throw new NullPointerException("Parameter 'data' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.transactionID != null && !this.transactionID.equals(TransactionBody.DEFAULT.transactionID)) {
            result = 31 * result + this.transactionID.hashCode();
        }
        if (this.nodeAccountID != null && !this.nodeAccountID.equals(TransactionBody.DEFAULT.nodeAccountID)) {
            result = 31 * result + this.nodeAccountID.hashCode();
        }
        if (this.transactionFee != TransactionBody.DEFAULT.transactionFee) {
            result = 31 * result + Long.hashCode(this.transactionFee);
        }
        if (this.transactionValidDuration != null && !this.transactionValidDuration.equals(TransactionBody.DEFAULT.transactionValidDuration)) {
            result = 31 * result + this.transactionValidDuration.hashCode();
        }
        if (this.generateRecord != TransactionBody.DEFAULT.generateRecord) {
            result = 31 * result + Boolean.hashCode(this.generateRecord);
        }
        if (this.memo != null && !this.memo.equals(TransactionBody.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.data != null && !this.data.equals(TransactionBody.DEFAULT.data)) {
            result = 31 * result + this.data.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionBody thatObj = (TransactionBody)that;
        if (this.transactionID == null && thatObj.transactionID != null) {
            return false;
        }
        if (this.transactionID != null && !this.transactionID.equals(thatObj.transactionID)) {
            return false;
        }
        if (this.nodeAccountID == null && thatObj.nodeAccountID != null) {
            return false;
        }
        if (this.nodeAccountID != null && !this.nodeAccountID.equals(thatObj.nodeAccountID)) {
            return false;
        }
        if (this.transactionFee != thatObj.transactionFee) {
            return false;
        }
        if (this.transactionValidDuration == null && thatObj.transactionValidDuration != null) {
            return false;
        }
        if (this.transactionValidDuration != null && !this.transactionValidDuration.equals(thatObj.transactionValidDuration)) {
            return false;
        }
        if (this.generateRecord != thatObj.generateRecord) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.data == null && thatObj.data != null) {
            return false;
        }
        return this.data == null || this.data.equals(thatObj.data);
    }

    public boolean hasTransactionID() {
        return this.transactionID != null;
    }

    public TransactionID transactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasTransactionID() ? this.transactionID : defaultValue;
    }

    @NonNull
    public TransactionID transactionIDOrThrow() {
        return Objects.requireNonNull(this.transactionID, "Field transactionID is null");
    }

    public void ifTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasTransactionID()) {
            ifPresent.accept(this.transactionID);
        }
    }

    public boolean hasNodeAccountID() {
        return this.nodeAccountID != null;
    }

    public AccountID nodeAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasNodeAccountID() ? this.nodeAccountID : defaultValue;
    }

    @NonNull
    public AccountID nodeAccountIDOrThrow() {
        return Objects.requireNonNull(this.nodeAccountID, "Field nodeAccountID is null");
    }

    public void ifNodeAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasNodeAccountID()) {
            ifPresent.accept(this.nodeAccountID);
        }
    }

    public boolean hasTransactionValidDuration() {
        return this.transactionValidDuration != null;
    }

    public Duration transactionValidDurationOrElse(@NonNull Duration defaultValue) {
        return this.hasTransactionValidDuration() ? this.transactionValidDuration : defaultValue;
    }

    @NonNull
    public Duration transactionValidDurationOrThrow() {
        return Objects.requireNonNull(this.transactionValidDuration, "Field transactionValidDuration is null");
    }

    public void ifTransactionValidDuration(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasTransactionValidDuration()) {
            ifPresent.accept(this.transactionValidDuration);
        }
    }

    @Nullable
    public ContractCallTransactionBody contractCall() {
        return this.data.kind() == DataOneOfType.CONTRACT_CALL ? (ContractCallTransactionBody)this.data.value() : null;
    }

    public boolean hasContractCall() {
        return this.data.kind() == DataOneOfType.CONTRACT_CALL;
    }

    public ContractCallTransactionBody contractCallOrElse(@NonNull ContractCallTransactionBody defaultValue) {
        return this.hasContractCall() ? this.contractCall() : defaultValue;
    }

    @NonNull
    public ContractCallTransactionBody contractCallOrThrow() {
        return Objects.requireNonNull(this.contractCall(), "Field contractCall is null");
    }

    @Nullable
    public ContractCreateTransactionBody contractCreateInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_CREATE_INSTANCE ? (ContractCreateTransactionBody)this.data.value() : null;
    }

    public boolean hasContractCreateInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_CREATE_INSTANCE;
    }

    public ContractCreateTransactionBody contractCreateInstanceOrElse(@NonNull ContractCreateTransactionBody defaultValue) {
        return this.hasContractCreateInstance() ? this.contractCreateInstance() : defaultValue;
    }

    @NonNull
    public ContractCreateTransactionBody contractCreateInstanceOrThrow() {
        return Objects.requireNonNull(this.contractCreateInstance(), "Field contractCreateInstance is null");
    }

    @Nullable
    public ContractUpdateTransactionBody contractUpdateInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_UPDATE_INSTANCE ? (ContractUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasContractUpdateInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_UPDATE_INSTANCE;
    }

    public ContractUpdateTransactionBody contractUpdateInstanceOrElse(@NonNull ContractUpdateTransactionBody defaultValue) {
        return this.hasContractUpdateInstance() ? this.contractUpdateInstance() : defaultValue;
    }

    @NonNull
    public ContractUpdateTransactionBody contractUpdateInstanceOrThrow() {
        return Objects.requireNonNull(this.contractUpdateInstance(), "Field contractUpdateInstance is null");
    }

    @Nullable
    public ContractDeleteTransactionBody contractDeleteInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_DELETE_INSTANCE ? (ContractDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasContractDeleteInstance() {
        return this.data.kind() == DataOneOfType.CONTRACT_DELETE_INSTANCE;
    }

    public ContractDeleteTransactionBody contractDeleteInstanceOrElse(@NonNull ContractDeleteTransactionBody defaultValue) {
        return this.hasContractDeleteInstance() ? this.contractDeleteInstance() : defaultValue;
    }

    @NonNull
    public ContractDeleteTransactionBody contractDeleteInstanceOrThrow() {
        return Objects.requireNonNull(this.contractDeleteInstance(), "Field contractDeleteInstance is null");
    }

    @Nullable
    public EthereumTransactionBody ethereumTransaction() {
        return this.data.kind() == DataOneOfType.ETHEREUM_TRANSACTION ? (EthereumTransactionBody)this.data.value() : null;
    }

    public boolean hasEthereumTransaction() {
        return this.data.kind() == DataOneOfType.ETHEREUM_TRANSACTION;
    }

    public EthereumTransactionBody ethereumTransactionOrElse(@NonNull EthereumTransactionBody defaultValue) {
        return this.hasEthereumTransaction() ? this.ethereumTransaction() : defaultValue;
    }

    @NonNull
    public EthereumTransactionBody ethereumTransactionOrThrow() {
        return Objects.requireNonNull(this.ethereumTransaction(), "Field ethereumTransaction is null");
    }

    @Nullable
    public CryptoAddLiveHashTransactionBody cryptoAddLiveHash() {
        return this.data.kind() == DataOneOfType.CRYPTO_ADD_LIVE_HASH ? (CryptoAddLiveHashTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoAddLiveHash() {
        return this.data.kind() == DataOneOfType.CRYPTO_ADD_LIVE_HASH;
    }

    public CryptoAddLiveHashTransactionBody cryptoAddLiveHashOrElse(@NonNull CryptoAddLiveHashTransactionBody defaultValue) {
        return this.hasCryptoAddLiveHash() ? this.cryptoAddLiveHash() : defaultValue;
    }

    @NonNull
    public CryptoAddLiveHashTransactionBody cryptoAddLiveHashOrThrow() {
        return Objects.requireNonNull(this.cryptoAddLiveHash(), "Field cryptoAddLiveHash is null");
    }

    @Nullable
    public CryptoApproveAllowanceTransactionBody cryptoApproveAllowance() {
        return this.data.kind() == DataOneOfType.CRYPTO_APPROVE_ALLOWANCE ? (CryptoApproveAllowanceTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoApproveAllowance() {
        return this.data.kind() == DataOneOfType.CRYPTO_APPROVE_ALLOWANCE;
    }

    public CryptoApproveAllowanceTransactionBody cryptoApproveAllowanceOrElse(@NonNull CryptoApproveAllowanceTransactionBody defaultValue) {
        return this.hasCryptoApproveAllowance() ? this.cryptoApproveAllowance() : defaultValue;
    }

    @NonNull
    public CryptoApproveAllowanceTransactionBody cryptoApproveAllowanceOrThrow() {
        return Objects.requireNonNull(this.cryptoApproveAllowance(), "Field cryptoApproveAllowance is null");
    }

    @Nullable
    public CryptoDeleteAllowanceTransactionBody cryptoDeleteAllowance() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE_ALLOWANCE ? (CryptoDeleteAllowanceTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoDeleteAllowance() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE_ALLOWANCE;
    }

    public CryptoDeleteAllowanceTransactionBody cryptoDeleteAllowanceOrElse(@NonNull CryptoDeleteAllowanceTransactionBody defaultValue) {
        return this.hasCryptoDeleteAllowance() ? this.cryptoDeleteAllowance() : defaultValue;
    }

    @NonNull
    public CryptoDeleteAllowanceTransactionBody cryptoDeleteAllowanceOrThrow() {
        return Objects.requireNonNull(this.cryptoDeleteAllowance(), "Field cryptoDeleteAllowance is null");
    }

    @Nullable
    public CryptoCreateTransactionBody cryptoCreateAccount() {
        return this.data.kind() == DataOneOfType.CRYPTO_CREATE_ACCOUNT ? (CryptoCreateTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoCreateAccount() {
        return this.data.kind() == DataOneOfType.CRYPTO_CREATE_ACCOUNT;
    }

    public CryptoCreateTransactionBody cryptoCreateAccountOrElse(@NonNull CryptoCreateTransactionBody defaultValue) {
        return this.hasCryptoCreateAccount() ? this.cryptoCreateAccount() : defaultValue;
    }

    @NonNull
    public CryptoCreateTransactionBody cryptoCreateAccountOrThrow() {
        return Objects.requireNonNull(this.cryptoCreateAccount(), "Field cryptoCreateAccount is null");
    }

    @Nullable
    public CryptoDeleteTransactionBody cryptoDelete() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE ? (CryptoDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoDelete() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE;
    }

    public CryptoDeleteTransactionBody cryptoDeleteOrElse(@NonNull CryptoDeleteTransactionBody defaultValue) {
        return this.hasCryptoDelete() ? this.cryptoDelete() : defaultValue;
    }

    @NonNull
    public CryptoDeleteTransactionBody cryptoDeleteOrThrow() {
        return Objects.requireNonNull(this.cryptoDelete(), "Field cryptoDelete is null");
    }

    @Nullable
    public CryptoDeleteLiveHashTransactionBody cryptoDeleteLiveHash() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE_LIVE_HASH ? (CryptoDeleteLiveHashTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoDeleteLiveHash() {
        return this.data.kind() == DataOneOfType.CRYPTO_DELETE_LIVE_HASH;
    }

    public CryptoDeleteLiveHashTransactionBody cryptoDeleteLiveHashOrElse(@NonNull CryptoDeleteLiveHashTransactionBody defaultValue) {
        return this.hasCryptoDeleteLiveHash() ? this.cryptoDeleteLiveHash() : defaultValue;
    }

    @NonNull
    public CryptoDeleteLiveHashTransactionBody cryptoDeleteLiveHashOrThrow() {
        return Objects.requireNonNull(this.cryptoDeleteLiveHash(), "Field cryptoDeleteLiveHash is null");
    }

    @Nullable
    public CryptoTransferTransactionBody cryptoTransfer() {
        return this.data.kind() == DataOneOfType.CRYPTO_TRANSFER ? (CryptoTransferTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoTransfer() {
        return this.data.kind() == DataOneOfType.CRYPTO_TRANSFER;
    }

    public CryptoTransferTransactionBody cryptoTransferOrElse(@NonNull CryptoTransferTransactionBody defaultValue) {
        return this.hasCryptoTransfer() ? this.cryptoTransfer() : defaultValue;
    }

    @NonNull
    public CryptoTransferTransactionBody cryptoTransferOrThrow() {
        return Objects.requireNonNull(this.cryptoTransfer(), "Field cryptoTransfer is null");
    }

    @Nullable
    public CryptoUpdateTransactionBody cryptoUpdateAccount() {
        return this.data.kind() == DataOneOfType.CRYPTO_UPDATE_ACCOUNT ? (CryptoUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasCryptoUpdateAccount() {
        return this.data.kind() == DataOneOfType.CRYPTO_UPDATE_ACCOUNT;
    }

    public CryptoUpdateTransactionBody cryptoUpdateAccountOrElse(@NonNull CryptoUpdateTransactionBody defaultValue) {
        return this.hasCryptoUpdateAccount() ? this.cryptoUpdateAccount() : defaultValue;
    }

    @NonNull
    public CryptoUpdateTransactionBody cryptoUpdateAccountOrThrow() {
        return Objects.requireNonNull(this.cryptoUpdateAccount(), "Field cryptoUpdateAccount is null");
    }

    @Nullable
    public FileAppendTransactionBody fileAppend() {
        return this.data.kind() == DataOneOfType.FILE_APPEND ? (FileAppendTransactionBody)this.data.value() : null;
    }

    public boolean hasFileAppend() {
        return this.data.kind() == DataOneOfType.FILE_APPEND;
    }

    public FileAppendTransactionBody fileAppendOrElse(@NonNull FileAppendTransactionBody defaultValue) {
        return this.hasFileAppend() ? this.fileAppend() : defaultValue;
    }

    @NonNull
    public FileAppendTransactionBody fileAppendOrThrow() {
        return Objects.requireNonNull(this.fileAppend(), "Field fileAppend is null");
    }

    @Nullable
    public FileCreateTransactionBody fileCreate() {
        return this.data.kind() == DataOneOfType.FILE_CREATE ? (FileCreateTransactionBody)this.data.value() : null;
    }

    public boolean hasFileCreate() {
        return this.data.kind() == DataOneOfType.FILE_CREATE;
    }

    public FileCreateTransactionBody fileCreateOrElse(@NonNull FileCreateTransactionBody defaultValue) {
        return this.hasFileCreate() ? this.fileCreate() : defaultValue;
    }

    @NonNull
    public FileCreateTransactionBody fileCreateOrThrow() {
        return Objects.requireNonNull(this.fileCreate(), "Field fileCreate is null");
    }

    @Nullable
    public FileDeleteTransactionBody fileDelete() {
        return this.data.kind() == DataOneOfType.FILE_DELETE ? (FileDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasFileDelete() {
        return this.data.kind() == DataOneOfType.FILE_DELETE;
    }

    public FileDeleteTransactionBody fileDeleteOrElse(@NonNull FileDeleteTransactionBody defaultValue) {
        return this.hasFileDelete() ? this.fileDelete() : defaultValue;
    }

    @NonNull
    public FileDeleteTransactionBody fileDeleteOrThrow() {
        return Objects.requireNonNull(this.fileDelete(), "Field fileDelete is null");
    }

    @Nullable
    public FileUpdateTransactionBody fileUpdate() {
        return this.data.kind() == DataOneOfType.FILE_UPDATE ? (FileUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasFileUpdate() {
        return this.data.kind() == DataOneOfType.FILE_UPDATE;
    }

    public FileUpdateTransactionBody fileUpdateOrElse(@NonNull FileUpdateTransactionBody defaultValue) {
        return this.hasFileUpdate() ? this.fileUpdate() : defaultValue;
    }

    @NonNull
    public FileUpdateTransactionBody fileUpdateOrThrow() {
        return Objects.requireNonNull(this.fileUpdate(), "Field fileUpdate is null");
    }

    @Nullable
    public SystemDeleteTransactionBody systemDelete() {
        return this.data.kind() == DataOneOfType.SYSTEM_DELETE ? (SystemDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasSystemDelete() {
        return this.data.kind() == DataOneOfType.SYSTEM_DELETE;
    }

    public SystemDeleteTransactionBody systemDeleteOrElse(@NonNull SystemDeleteTransactionBody defaultValue) {
        return this.hasSystemDelete() ? this.systemDelete() : defaultValue;
    }

    @NonNull
    public SystemDeleteTransactionBody systemDeleteOrThrow() {
        return Objects.requireNonNull(this.systemDelete(), "Field systemDelete is null");
    }

    @Nullable
    public SystemUndeleteTransactionBody systemUndelete() {
        return this.data.kind() == DataOneOfType.SYSTEM_UNDELETE ? (SystemUndeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasSystemUndelete() {
        return this.data.kind() == DataOneOfType.SYSTEM_UNDELETE;
    }

    public SystemUndeleteTransactionBody systemUndeleteOrElse(@NonNull SystemUndeleteTransactionBody defaultValue) {
        return this.hasSystemUndelete() ? this.systemUndelete() : defaultValue;
    }

    @NonNull
    public SystemUndeleteTransactionBody systemUndeleteOrThrow() {
        return Objects.requireNonNull(this.systemUndelete(), "Field systemUndelete is null");
    }

    @Nullable
    public FreezeTransactionBody freeze() {
        return this.data.kind() == DataOneOfType.FREEZE ? (FreezeTransactionBody)this.data.value() : null;
    }

    public boolean hasFreeze() {
        return this.data.kind() == DataOneOfType.FREEZE;
    }

    public FreezeTransactionBody freezeOrElse(@NonNull FreezeTransactionBody defaultValue) {
        return this.hasFreeze() ? this.freeze() : defaultValue;
    }

    @NonNull
    public FreezeTransactionBody freezeOrThrow() {
        return Objects.requireNonNull(this.freeze(), "Field freeze is null");
    }

    @Nullable
    public ConsensusCreateTopicTransactionBody consensusCreateTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_CREATE_TOPIC ? (ConsensusCreateTopicTransactionBody)this.data.value() : null;
    }

    public boolean hasConsensusCreateTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_CREATE_TOPIC;
    }

    public ConsensusCreateTopicTransactionBody consensusCreateTopicOrElse(@NonNull ConsensusCreateTopicTransactionBody defaultValue) {
        return this.hasConsensusCreateTopic() ? this.consensusCreateTopic() : defaultValue;
    }

    @NonNull
    public ConsensusCreateTopicTransactionBody consensusCreateTopicOrThrow() {
        return Objects.requireNonNull(this.consensusCreateTopic(), "Field consensusCreateTopic is null");
    }

    @Nullable
    public ConsensusUpdateTopicTransactionBody consensusUpdateTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_UPDATE_TOPIC ? (ConsensusUpdateTopicTransactionBody)this.data.value() : null;
    }

    public boolean hasConsensusUpdateTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_UPDATE_TOPIC;
    }

    public ConsensusUpdateTopicTransactionBody consensusUpdateTopicOrElse(@NonNull ConsensusUpdateTopicTransactionBody defaultValue) {
        return this.hasConsensusUpdateTopic() ? this.consensusUpdateTopic() : defaultValue;
    }

    @NonNull
    public ConsensusUpdateTopicTransactionBody consensusUpdateTopicOrThrow() {
        return Objects.requireNonNull(this.consensusUpdateTopic(), "Field consensusUpdateTopic is null");
    }

    @Nullable
    public ConsensusDeleteTopicTransactionBody consensusDeleteTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_DELETE_TOPIC ? (ConsensusDeleteTopicTransactionBody)this.data.value() : null;
    }

    public boolean hasConsensusDeleteTopic() {
        return this.data.kind() == DataOneOfType.CONSENSUS_DELETE_TOPIC;
    }

    public ConsensusDeleteTopicTransactionBody consensusDeleteTopicOrElse(@NonNull ConsensusDeleteTopicTransactionBody defaultValue) {
        return this.hasConsensusDeleteTopic() ? this.consensusDeleteTopic() : defaultValue;
    }

    @NonNull
    public ConsensusDeleteTopicTransactionBody consensusDeleteTopicOrThrow() {
        return Objects.requireNonNull(this.consensusDeleteTopic(), "Field consensusDeleteTopic is null");
    }

    @Nullable
    public ConsensusSubmitMessageTransactionBody consensusSubmitMessage() {
        return this.data.kind() == DataOneOfType.CONSENSUS_SUBMIT_MESSAGE ? (ConsensusSubmitMessageTransactionBody)this.data.value() : null;
    }

    public boolean hasConsensusSubmitMessage() {
        return this.data.kind() == DataOneOfType.CONSENSUS_SUBMIT_MESSAGE;
    }

    public ConsensusSubmitMessageTransactionBody consensusSubmitMessageOrElse(@NonNull ConsensusSubmitMessageTransactionBody defaultValue) {
        return this.hasConsensusSubmitMessage() ? this.consensusSubmitMessage() : defaultValue;
    }

    @NonNull
    public ConsensusSubmitMessageTransactionBody consensusSubmitMessageOrThrow() {
        return Objects.requireNonNull(this.consensusSubmitMessage(), "Field consensusSubmitMessage is null");
    }

    @Nullable
    public UncheckedSubmitBody uncheckedSubmit() {
        return this.data.kind() == DataOneOfType.UNCHECKED_SUBMIT ? (UncheckedSubmitBody)this.data.value() : null;
    }

    public boolean hasUncheckedSubmit() {
        return this.data.kind() == DataOneOfType.UNCHECKED_SUBMIT;
    }

    public UncheckedSubmitBody uncheckedSubmitOrElse(@NonNull UncheckedSubmitBody defaultValue) {
        return this.hasUncheckedSubmit() ? this.uncheckedSubmit() : defaultValue;
    }

    @NonNull
    public UncheckedSubmitBody uncheckedSubmitOrThrow() {
        return Objects.requireNonNull(this.uncheckedSubmit(), "Field uncheckedSubmit is null");
    }

    @Nullable
    public TokenCreateTransactionBody tokenCreation() {
        return this.data.kind() == DataOneOfType.TOKEN_CREATION ? (TokenCreateTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenCreation() {
        return this.data.kind() == DataOneOfType.TOKEN_CREATION;
    }

    public TokenCreateTransactionBody tokenCreationOrElse(@NonNull TokenCreateTransactionBody defaultValue) {
        return this.hasTokenCreation() ? this.tokenCreation() : defaultValue;
    }

    @NonNull
    public TokenCreateTransactionBody tokenCreationOrThrow() {
        return Objects.requireNonNull(this.tokenCreation(), "Field tokenCreation is null");
    }

    @Nullable
    public TokenFreezeAccountTransactionBody tokenFreeze() {
        return this.data.kind() == DataOneOfType.TOKEN_FREEZE ? (TokenFreezeAccountTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenFreeze() {
        return this.data.kind() == DataOneOfType.TOKEN_FREEZE;
    }

    public TokenFreezeAccountTransactionBody tokenFreezeOrElse(@NonNull TokenFreezeAccountTransactionBody defaultValue) {
        return this.hasTokenFreeze() ? this.tokenFreeze() : defaultValue;
    }

    @NonNull
    public TokenFreezeAccountTransactionBody tokenFreezeOrThrow() {
        return Objects.requireNonNull(this.tokenFreeze(), "Field tokenFreeze is null");
    }

    @Nullable
    public TokenUnfreezeAccountTransactionBody tokenUnfreeze() {
        return this.data.kind() == DataOneOfType.TOKEN_UNFREEZE ? (TokenUnfreezeAccountTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenUnfreeze() {
        return this.data.kind() == DataOneOfType.TOKEN_UNFREEZE;
    }

    public TokenUnfreezeAccountTransactionBody tokenUnfreezeOrElse(@NonNull TokenUnfreezeAccountTransactionBody defaultValue) {
        return this.hasTokenUnfreeze() ? this.tokenUnfreeze() : defaultValue;
    }

    @NonNull
    public TokenUnfreezeAccountTransactionBody tokenUnfreezeOrThrow() {
        return Objects.requireNonNull(this.tokenUnfreeze(), "Field tokenUnfreeze is null");
    }

    @Nullable
    public TokenGrantKycTransactionBody tokenGrantKyc() {
        return this.data.kind() == DataOneOfType.TOKEN_GRANT_KYC ? (TokenGrantKycTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenGrantKyc() {
        return this.data.kind() == DataOneOfType.TOKEN_GRANT_KYC;
    }

    public TokenGrantKycTransactionBody tokenGrantKycOrElse(@NonNull TokenGrantKycTransactionBody defaultValue) {
        return this.hasTokenGrantKyc() ? this.tokenGrantKyc() : defaultValue;
    }

    @NonNull
    public TokenGrantKycTransactionBody tokenGrantKycOrThrow() {
        return Objects.requireNonNull(this.tokenGrantKyc(), "Field tokenGrantKyc is null");
    }

    @Nullable
    public TokenRevokeKycTransactionBody tokenRevokeKyc() {
        return this.data.kind() == DataOneOfType.TOKEN_REVOKE_KYC ? (TokenRevokeKycTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenRevokeKyc() {
        return this.data.kind() == DataOneOfType.TOKEN_REVOKE_KYC;
    }

    public TokenRevokeKycTransactionBody tokenRevokeKycOrElse(@NonNull TokenRevokeKycTransactionBody defaultValue) {
        return this.hasTokenRevokeKyc() ? this.tokenRevokeKyc() : defaultValue;
    }

    @NonNull
    public TokenRevokeKycTransactionBody tokenRevokeKycOrThrow() {
        return Objects.requireNonNull(this.tokenRevokeKyc(), "Field tokenRevokeKyc is null");
    }

    @Nullable
    public TokenDeleteTransactionBody tokenDeletion() {
        return this.data.kind() == DataOneOfType.TOKEN_DELETION ? (TokenDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenDeletion() {
        return this.data.kind() == DataOneOfType.TOKEN_DELETION;
    }

    public TokenDeleteTransactionBody tokenDeletionOrElse(@NonNull TokenDeleteTransactionBody defaultValue) {
        return this.hasTokenDeletion() ? this.tokenDeletion() : defaultValue;
    }

    @NonNull
    public TokenDeleteTransactionBody tokenDeletionOrThrow() {
        return Objects.requireNonNull(this.tokenDeletion(), "Field tokenDeletion is null");
    }

    @Nullable
    public TokenUpdateTransactionBody tokenUpdate() {
        return this.data.kind() == DataOneOfType.TOKEN_UPDATE ? (TokenUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenUpdate() {
        return this.data.kind() == DataOneOfType.TOKEN_UPDATE;
    }

    public TokenUpdateTransactionBody tokenUpdateOrElse(@NonNull TokenUpdateTransactionBody defaultValue) {
        return this.hasTokenUpdate() ? this.tokenUpdate() : defaultValue;
    }

    @NonNull
    public TokenUpdateTransactionBody tokenUpdateOrThrow() {
        return Objects.requireNonNull(this.tokenUpdate(), "Field tokenUpdate is null");
    }

    @Nullable
    public TokenMintTransactionBody tokenMint() {
        return this.data.kind() == DataOneOfType.TOKEN_MINT ? (TokenMintTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenMint() {
        return this.data.kind() == DataOneOfType.TOKEN_MINT;
    }

    public TokenMintTransactionBody tokenMintOrElse(@NonNull TokenMintTransactionBody defaultValue) {
        return this.hasTokenMint() ? this.tokenMint() : defaultValue;
    }

    @NonNull
    public TokenMintTransactionBody tokenMintOrThrow() {
        return Objects.requireNonNull(this.tokenMint(), "Field tokenMint is null");
    }

    @Nullable
    public TokenBurnTransactionBody tokenBurn() {
        return this.data.kind() == DataOneOfType.TOKEN_BURN ? (TokenBurnTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenBurn() {
        return this.data.kind() == DataOneOfType.TOKEN_BURN;
    }

    public TokenBurnTransactionBody tokenBurnOrElse(@NonNull TokenBurnTransactionBody defaultValue) {
        return this.hasTokenBurn() ? this.tokenBurn() : defaultValue;
    }

    @NonNull
    public TokenBurnTransactionBody tokenBurnOrThrow() {
        return Objects.requireNonNull(this.tokenBurn(), "Field tokenBurn is null");
    }

    @Nullable
    public TokenWipeAccountTransactionBody tokenWipe() {
        return this.data.kind() == DataOneOfType.TOKEN_WIPE ? (TokenWipeAccountTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenWipe() {
        return this.data.kind() == DataOneOfType.TOKEN_WIPE;
    }

    public TokenWipeAccountTransactionBody tokenWipeOrElse(@NonNull TokenWipeAccountTransactionBody defaultValue) {
        return this.hasTokenWipe() ? this.tokenWipe() : defaultValue;
    }

    @NonNull
    public TokenWipeAccountTransactionBody tokenWipeOrThrow() {
        return Objects.requireNonNull(this.tokenWipe(), "Field tokenWipe is null");
    }

    @Nullable
    public TokenAssociateTransactionBody tokenAssociate() {
        return this.data.kind() == DataOneOfType.TOKEN_ASSOCIATE ? (TokenAssociateTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenAssociate() {
        return this.data.kind() == DataOneOfType.TOKEN_ASSOCIATE;
    }

    public TokenAssociateTransactionBody tokenAssociateOrElse(@NonNull TokenAssociateTransactionBody defaultValue) {
        return this.hasTokenAssociate() ? this.tokenAssociate() : defaultValue;
    }

    @NonNull
    public TokenAssociateTransactionBody tokenAssociateOrThrow() {
        return Objects.requireNonNull(this.tokenAssociate(), "Field tokenAssociate is null");
    }

    @Nullable
    public TokenDissociateTransactionBody tokenDissociate() {
        return this.data.kind() == DataOneOfType.TOKEN_DISSOCIATE ? (TokenDissociateTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenDissociate() {
        return this.data.kind() == DataOneOfType.TOKEN_DISSOCIATE;
    }

    public TokenDissociateTransactionBody tokenDissociateOrElse(@NonNull TokenDissociateTransactionBody defaultValue) {
        return this.hasTokenDissociate() ? this.tokenDissociate() : defaultValue;
    }

    @NonNull
    public TokenDissociateTransactionBody tokenDissociateOrThrow() {
        return Objects.requireNonNull(this.tokenDissociate(), "Field tokenDissociate is null");
    }

    @Nullable
    public TokenFeeScheduleUpdateTransactionBody tokenFeeScheduleUpdate() {
        return this.data.kind() == DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE ? (TokenFeeScheduleUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenFeeScheduleUpdate() {
        return this.data.kind() == DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE;
    }

    public TokenFeeScheduleUpdateTransactionBody tokenFeeScheduleUpdateOrElse(@NonNull TokenFeeScheduleUpdateTransactionBody defaultValue) {
        return this.hasTokenFeeScheduleUpdate() ? this.tokenFeeScheduleUpdate() : defaultValue;
    }

    @NonNull
    public TokenFeeScheduleUpdateTransactionBody tokenFeeScheduleUpdateOrThrow() {
        return Objects.requireNonNull(this.tokenFeeScheduleUpdate(), "Field tokenFeeScheduleUpdate is null");
    }

    @Nullable
    public TokenPauseTransactionBody tokenPause() {
        return this.data.kind() == DataOneOfType.TOKEN_PAUSE ? (TokenPauseTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenPause() {
        return this.data.kind() == DataOneOfType.TOKEN_PAUSE;
    }

    public TokenPauseTransactionBody tokenPauseOrElse(@NonNull TokenPauseTransactionBody defaultValue) {
        return this.hasTokenPause() ? this.tokenPause() : defaultValue;
    }

    @NonNull
    public TokenPauseTransactionBody tokenPauseOrThrow() {
        return Objects.requireNonNull(this.tokenPause(), "Field tokenPause is null");
    }

    @Nullable
    public TokenUnpauseTransactionBody tokenUnpause() {
        return this.data.kind() == DataOneOfType.TOKEN_UNPAUSE ? (TokenUnpauseTransactionBody)this.data.value() : null;
    }

    public boolean hasTokenUnpause() {
        return this.data.kind() == DataOneOfType.TOKEN_UNPAUSE;
    }

    public TokenUnpauseTransactionBody tokenUnpauseOrElse(@NonNull TokenUnpauseTransactionBody defaultValue) {
        return this.hasTokenUnpause() ? this.tokenUnpause() : defaultValue;
    }

    @NonNull
    public TokenUnpauseTransactionBody tokenUnpauseOrThrow() {
        return Objects.requireNonNull(this.tokenUnpause(), "Field tokenUnpause is null");
    }

    @Nullable
    public ScheduleCreateTransactionBody scheduleCreate() {
        return this.data.kind() == DataOneOfType.SCHEDULE_CREATE ? (ScheduleCreateTransactionBody)this.data.value() : null;
    }

    public boolean hasScheduleCreate() {
        return this.data.kind() == DataOneOfType.SCHEDULE_CREATE;
    }

    public ScheduleCreateTransactionBody scheduleCreateOrElse(@NonNull ScheduleCreateTransactionBody defaultValue) {
        return this.hasScheduleCreate() ? this.scheduleCreate() : defaultValue;
    }

    @NonNull
    public ScheduleCreateTransactionBody scheduleCreateOrThrow() {
        return Objects.requireNonNull(this.scheduleCreate(), "Field scheduleCreate is null");
    }

    @Nullable
    public ScheduleDeleteTransactionBody scheduleDelete() {
        return this.data.kind() == DataOneOfType.SCHEDULE_DELETE ? (ScheduleDeleteTransactionBody)this.data.value() : null;
    }

    public boolean hasScheduleDelete() {
        return this.data.kind() == DataOneOfType.SCHEDULE_DELETE;
    }

    public ScheduleDeleteTransactionBody scheduleDeleteOrElse(@NonNull ScheduleDeleteTransactionBody defaultValue) {
        return this.hasScheduleDelete() ? this.scheduleDelete() : defaultValue;
    }

    @NonNull
    public ScheduleDeleteTransactionBody scheduleDeleteOrThrow() {
        return Objects.requireNonNull(this.scheduleDelete(), "Field scheduleDelete is null");
    }

    @Nullable
    public ScheduleSignTransactionBody scheduleSign() {
        return this.data.kind() == DataOneOfType.SCHEDULE_SIGN ? (ScheduleSignTransactionBody)this.data.value() : null;
    }

    public boolean hasScheduleSign() {
        return this.data.kind() == DataOneOfType.SCHEDULE_SIGN;
    }

    public ScheduleSignTransactionBody scheduleSignOrElse(@NonNull ScheduleSignTransactionBody defaultValue) {
        return this.hasScheduleSign() ? this.scheduleSign() : defaultValue;
    }

    @NonNull
    public ScheduleSignTransactionBody scheduleSignOrThrow() {
        return Objects.requireNonNull(this.scheduleSign(), "Field scheduleSign is null");
    }

    @Nullable
    public NodeStakeUpdateTransactionBody nodeStakeUpdate() {
        return this.data.kind() == DataOneOfType.NODE_STAKE_UPDATE ? (NodeStakeUpdateTransactionBody)this.data.value() : null;
    }

    public boolean hasNodeStakeUpdate() {
        return this.data.kind() == DataOneOfType.NODE_STAKE_UPDATE;
    }

    public NodeStakeUpdateTransactionBody nodeStakeUpdateOrElse(@NonNull NodeStakeUpdateTransactionBody defaultValue) {
        return this.hasNodeStakeUpdate() ? this.nodeStakeUpdate() : defaultValue;
    }

    @NonNull
    public NodeStakeUpdateTransactionBody nodeStakeUpdateOrThrow() {
        return Objects.requireNonNull(this.nodeStakeUpdate(), "Field nodeStakeUpdate is null");
    }

    @Nullable
    public UtilPrngTransactionBody utilPrng() {
        return this.data.kind() == DataOneOfType.UTIL_PRNG ? (UtilPrngTransactionBody)this.data.value() : null;
    }

    public boolean hasUtilPrng() {
        return this.data.kind() == DataOneOfType.UTIL_PRNG;
    }

    public UtilPrngTransactionBody utilPrngOrElse(@NonNull UtilPrngTransactionBody defaultValue) {
        return this.hasUtilPrng() ? this.utilPrng() : defaultValue;
    }

    @NonNull
    public UtilPrngTransactionBody utilPrngOrThrow() {
        return Objects.requireNonNull(this.utilPrng(), "Field utilPrng is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.transactionID, this.nodeAccountID, this.transactionFee, this.transactionValidDuration, this.generateRecord, this.memo, this.data);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum DataOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT_CALL(7, "contractCall"),
        CONTRACT_CREATE_INSTANCE(8, "contractCreateInstance"),
        CONTRACT_UPDATE_INSTANCE(9, "contractUpdateInstance"),
        CRYPTO_ADD_LIVE_HASH(10, "cryptoAddLiveHash"),
        CRYPTO_CREATE_ACCOUNT(11, "cryptoCreateAccount"),
        CRYPTO_DELETE(12, "cryptoDelete"),
        CRYPTO_DELETE_LIVE_HASH(13, "cryptoDeleteLiveHash"),
        CRYPTO_TRANSFER(14, "cryptoTransfer"),
        CRYPTO_UPDATE_ACCOUNT(15, "cryptoUpdateAccount"),
        FILE_APPEND(16, "fileAppend"),
        FILE_CREATE(17, "fileCreate"),
        FILE_DELETE(18, "fileDelete"),
        FILE_UPDATE(19, "fileUpdate"),
        SYSTEM_DELETE(20, "systemDelete"),
        SYSTEM_UNDELETE(21, "systemUndelete"),
        CONTRACT_DELETE_INSTANCE(22, "contractDeleteInstance"),
        FREEZE(23, "freeze"),
        CONSENSUS_CREATE_TOPIC(24, "consensusCreateTopic"),
        CONSENSUS_UPDATE_TOPIC(25, "consensusUpdateTopic"),
        CONSENSUS_DELETE_TOPIC(26, "consensusDeleteTopic"),
        CONSENSUS_SUBMIT_MESSAGE(27, "consensusSubmitMessage"),
        UNCHECKED_SUBMIT(28, "uncheckedSubmit"),
        TOKEN_CREATION(29, "tokenCreation"),
        TOKEN_FREEZE(31, "tokenFreeze"),
        TOKEN_UNFREEZE(32, "tokenUnfreeze"),
        TOKEN_GRANT_KYC(33, "tokenGrantKyc"),
        TOKEN_REVOKE_KYC(34, "tokenRevokeKyc"),
        TOKEN_DELETION(35, "tokenDeletion"),
        TOKEN_UPDATE(36, "tokenUpdate"),
        TOKEN_MINT(37, "tokenMint"),
        TOKEN_BURN(38, "tokenBurn"),
        TOKEN_WIPE(39, "tokenWipe"),
        TOKEN_ASSOCIATE(40, "tokenAssociate"),
        TOKEN_DISSOCIATE(41, "tokenDissociate"),
        SCHEDULE_CREATE(42, "scheduleCreate"),
        SCHEDULE_DELETE(43, "scheduleDelete"),
        SCHEDULE_SIGN(44, "scheduleSign"),
        TOKEN_FEE_SCHEDULE_UPDATE(45, "token_fee_schedule_update"),
        TOKEN_PAUSE(46, "token_pause"),
        TOKEN_UNPAUSE(47, "token_unpause"),
        CRYPTO_APPROVE_ALLOWANCE(48, "cryptoApproveAllowance"),
        CRYPTO_DELETE_ALLOWANCE(49, "cryptoDeleteAllowance"),
        ETHEREUM_TRANSACTION(50, "ethereumTransaction"),
        NODE_STAKE_UPDATE(51, "node_stake_update"),
        UTIL_PRNG(52, "util_prng");

        private final int protoOrdinal;
        private final String protoName;

        private DataOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static DataOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 7 -> CONTRACT_CALL;
                case 8 -> CONTRACT_CREATE_INSTANCE;
                case 9 -> CONTRACT_UPDATE_INSTANCE;
                case 10 -> CRYPTO_ADD_LIVE_HASH;
                case 11 -> CRYPTO_CREATE_ACCOUNT;
                case 12 -> CRYPTO_DELETE;
                case 13 -> CRYPTO_DELETE_LIVE_HASH;
                case 14 -> CRYPTO_TRANSFER;
                case 15 -> CRYPTO_UPDATE_ACCOUNT;
                case 16 -> FILE_APPEND;
                case 17 -> FILE_CREATE;
                case 18 -> FILE_DELETE;
                case 19 -> FILE_UPDATE;
                case 20 -> SYSTEM_DELETE;
                case 21 -> SYSTEM_UNDELETE;
                case 22 -> CONTRACT_DELETE_INSTANCE;
                case 23 -> FREEZE;
                case 24 -> CONSENSUS_CREATE_TOPIC;
                case 25 -> CONSENSUS_UPDATE_TOPIC;
                case 26 -> CONSENSUS_DELETE_TOPIC;
                case 27 -> CONSENSUS_SUBMIT_MESSAGE;
                case 28 -> UNCHECKED_SUBMIT;
                case 29 -> TOKEN_CREATION;
                case 31 -> TOKEN_FREEZE;
                case 32 -> TOKEN_UNFREEZE;
                case 33 -> TOKEN_GRANT_KYC;
                case 34 -> TOKEN_REVOKE_KYC;
                case 35 -> TOKEN_DELETION;
                case 36 -> TOKEN_UPDATE;
                case 37 -> TOKEN_MINT;
                case 38 -> TOKEN_BURN;
                case 39 -> TOKEN_WIPE;
                case 40 -> TOKEN_ASSOCIATE;
                case 41 -> TOKEN_DISSOCIATE;
                case 42 -> SCHEDULE_CREATE;
                case 43 -> SCHEDULE_DELETE;
                case 44 -> SCHEDULE_SIGN;
                case 45 -> TOKEN_FEE_SCHEDULE_UPDATE;
                case 46 -> TOKEN_PAUSE;
                case 47 -> TOKEN_UNPAUSE;
                case 48 -> CRYPTO_APPROVE_ALLOWANCE;
                case 49 -> CRYPTO_DELETE_ALLOWANCE;
                case 50 -> ETHEREUM_TRANSACTION;
                case 51 -> NODE_STAKE_UPDATE;
                case 52 -> UTIL_PRNG;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static DataOneOfType fromString(String name) {
            return switch (name) {
                case "contractCall", "CONTRACT_CALL" -> CONTRACT_CALL;
                case "contractCreateInstance", "CONTRACT_CREATE_INSTANCE" -> CONTRACT_CREATE_INSTANCE;
                case "contractUpdateInstance", "CONTRACT_UPDATE_INSTANCE" -> CONTRACT_UPDATE_INSTANCE;
                case "cryptoAddLiveHash", "CRYPTO_ADD_LIVE_HASH" -> CRYPTO_ADD_LIVE_HASH;
                case "cryptoCreateAccount", "CRYPTO_CREATE_ACCOUNT" -> CRYPTO_CREATE_ACCOUNT;
                case "cryptoDelete", "CRYPTO_DELETE" -> CRYPTO_DELETE;
                case "cryptoDeleteLiveHash", "CRYPTO_DELETE_LIVE_HASH" -> CRYPTO_DELETE_LIVE_HASH;
                case "cryptoTransfer", "CRYPTO_TRANSFER" -> CRYPTO_TRANSFER;
                case "cryptoUpdateAccount", "CRYPTO_UPDATE_ACCOUNT" -> CRYPTO_UPDATE_ACCOUNT;
                case "fileAppend", "FILE_APPEND" -> FILE_APPEND;
                case "fileCreate", "FILE_CREATE" -> FILE_CREATE;
                case "fileDelete", "FILE_DELETE" -> FILE_DELETE;
                case "fileUpdate", "FILE_UPDATE" -> FILE_UPDATE;
                case "systemDelete", "SYSTEM_DELETE" -> SYSTEM_DELETE;
                case "systemUndelete", "SYSTEM_UNDELETE" -> SYSTEM_UNDELETE;
                case "contractDeleteInstance", "CONTRACT_DELETE_INSTANCE" -> CONTRACT_DELETE_INSTANCE;
                case "freeze", "FREEZE" -> FREEZE;
                case "consensusCreateTopic", "CONSENSUS_CREATE_TOPIC" -> CONSENSUS_CREATE_TOPIC;
                case "consensusUpdateTopic", "CONSENSUS_UPDATE_TOPIC" -> CONSENSUS_UPDATE_TOPIC;
                case "consensusDeleteTopic", "CONSENSUS_DELETE_TOPIC" -> CONSENSUS_DELETE_TOPIC;
                case "consensusSubmitMessage", "CONSENSUS_SUBMIT_MESSAGE" -> CONSENSUS_SUBMIT_MESSAGE;
                case "uncheckedSubmit", "UNCHECKED_SUBMIT" -> UNCHECKED_SUBMIT;
                case "tokenCreation", "TOKEN_CREATION" -> TOKEN_CREATION;
                case "tokenFreeze", "TOKEN_FREEZE" -> TOKEN_FREEZE;
                case "tokenUnfreeze", "TOKEN_UNFREEZE" -> TOKEN_UNFREEZE;
                case "tokenGrantKyc", "TOKEN_GRANT_KYC" -> TOKEN_GRANT_KYC;
                case "tokenRevokeKyc", "TOKEN_REVOKE_KYC" -> TOKEN_REVOKE_KYC;
                case "tokenDeletion", "TOKEN_DELETION" -> TOKEN_DELETION;
                case "tokenUpdate", "TOKEN_UPDATE" -> TOKEN_UPDATE;
                case "tokenMint", "TOKEN_MINT" -> TOKEN_MINT;
                case "tokenBurn", "TOKEN_BURN" -> TOKEN_BURN;
                case "tokenWipe", "TOKEN_WIPE" -> TOKEN_WIPE;
                case "tokenAssociate", "TOKEN_ASSOCIATE" -> TOKEN_ASSOCIATE;
                case "tokenDissociate", "TOKEN_DISSOCIATE" -> TOKEN_DISSOCIATE;
                case "scheduleCreate", "SCHEDULE_CREATE" -> SCHEDULE_CREATE;
                case "scheduleDelete", "SCHEDULE_DELETE" -> SCHEDULE_DELETE;
                case "scheduleSign", "SCHEDULE_SIGN" -> SCHEDULE_SIGN;
                case "token_fee_schedule_update", "TOKEN_FEE_SCHEDULE_UPDATE" -> TOKEN_FEE_SCHEDULE_UPDATE;
                case "token_pause", "TOKEN_PAUSE" -> TOKEN_PAUSE;
                case "token_unpause", "TOKEN_UNPAUSE" -> TOKEN_UNPAUSE;
                case "cryptoApproveAllowance", "CRYPTO_APPROVE_ALLOWANCE" -> CRYPTO_APPROVE_ALLOWANCE;
                case "cryptoDeleteAllowance", "CRYPTO_DELETE_ALLOWANCE" -> CRYPTO_DELETE_ALLOWANCE;
                case "ethereumTransaction", "ETHEREUM_TRANSACTION" -> ETHEREUM_TRANSACTION;
                case "node_stake_update", "NODE_STAKE_UPDATE" -> NODE_STAKE_UPDATE;
                case "util_prng", "UTIL_PRNG" -> UTIL_PRNG;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private TransactionID transactionID = null;
        private AccountID nodeAccountID = null;
        private long transactionFee = 0L;
        private Duration transactionValidDuration = null;
        private boolean generateRecord = false;
        private String memo = "";
        private OneOf<DataOneOfType> data = TransactionBodyProtoCodec.DATA_UNSET;

        public Builder() {
        }

        public Builder(TransactionID transactionID, AccountID nodeAccountID, long transactionFee, Duration transactionValidDuration, boolean generateRecord, String memo, OneOf<DataOneOfType> data) {
            this.transactionID = transactionID;
            this.nodeAccountID = nodeAccountID;
            this.transactionFee = transactionFee;
            this.transactionValidDuration = transactionValidDuration;
            this.generateRecord = generateRecord;
            this.memo = memo;
            this.data = data;
        }

        public TransactionBody build() {
            return new TransactionBody(this.transactionID, this.nodeAccountID, this.transactionFee, this.transactionValidDuration, this.generateRecord, this.memo, this.data);
        }

        public Builder transactionID(TransactionID transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder transactionID(TransactionID.Builder builder) {
            this.transactionID = builder.build();
            return this;
        }

        public Builder nodeAccountID(AccountID nodeAccountID) {
            this.nodeAccountID = nodeAccountID;
            return this;
        }

        public Builder nodeAccountID(AccountID.Builder builder) {
            this.nodeAccountID = builder.build();
            return this;
        }

        public Builder transactionFee(long transactionFee) {
            this.transactionFee = transactionFee;
            return this;
        }

        public Builder transactionValidDuration(Duration transactionValidDuration) {
            this.transactionValidDuration = transactionValidDuration;
            return this;
        }

        public Builder transactionValidDuration(Duration.Builder builder) {
            this.transactionValidDuration = builder.build();
            return this;
        }

        public Builder generateRecord(boolean generateRecord) {
            this.generateRecord = generateRecord;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder contractCall(ContractCallTransactionBody contractCall) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_CALL, (Object)contractCall);
            return this;
        }

        public Builder contractCall(ContractCallTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_CALL, (Object)builder.build());
            return this;
        }

        public Builder contractCreateInstance(ContractCreateTransactionBody contractCreateInstance) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_CREATE_INSTANCE, (Object)contractCreateInstance);
            return this;
        }

        public Builder contractCreateInstance(ContractCreateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_CREATE_INSTANCE, (Object)builder.build());
            return this;
        }

        public Builder contractUpdateInstance(ContractUpdateTransactionBody contractUpdateInstance) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_UPDATE_INSTANCE, (Object)contractUpdateInstance);
            return this;
        }

        public Builder contractUpdateInstance(ContractUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_UPDATE_INSTANCE, (Object)builder.build());
            return this;
        }

        public Builder contractDeleteInstance(ContractDeleteTransactionBody contractDeleteInstance) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_DELETE_INSTANCE, (Object)contractDeleteInstance);
            return this;
        }

        public Builder contractDeleteInstance(ContractDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONTRACT_DELETE_INSTANCE, (Object)builder.build());
            return this;
        }

        public Builder ethereumTransaction(EthereumTransactionBody ethereumTransaction) {
            this.data = new OneOf((Object)DataOneOfType.ETHEREUM_TRANSACTION, (Object)ethereumTransaction);
            return this;
        }

        public Builder ethereumTransaction(EthereumTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.ETHEREUM_TRANSACTION, (Object)builder.build());
            return this;
        }

        public Builder cryptoAddLiveHash(CryptoAddLiveHashTransactionBody cryptoAddLiveHash) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_ADD_LIVE_HASH, (Object)cryptoAddLiveHash);
            return this;
        }

        public Builder cryptoAddLiveHash(CryptoAddLiveHashTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_ADD_LIVE_HASH, (Object)builder.build());
            return this;
        }

        public Builder cryptoApproveAllowance(CryptoApproveAllowanceTransactionBody cryptoApproveAllowance) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_APPROVE_ALLOWANCE, (Object)cryptoApproveAllowance);
            return this;
        }

        public Builder cryptoApproveAllowance(CryptoApproveAllowanceTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_APPROVE_ALLOWANCE, (Object)builder.build());
            return this;
        }

        public Builder cryptoDeleteAllowance(CryptoDeleteAllowanceTransactionBody cryptoDeleteAllowance) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE_ALLOWANCE, (Object)cryptoDeleteAllowance);
            return this;
        }

        public Builder cryptoDeleteAllowance(CryptoDeleteAllowanceTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE_ALLOWANCE, (Object)builder.build());
            return this;
        }

        public Builder cryptoCreateAccount(CryptoCreateTransactionBody cryptoCreateAccount) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_CREATE_ACCOUNT, (Object)cryptoCreateAccount);
            return this;
        }

        public Builder cryptoCreateAccount(CryptoCreateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_CREATE_ACCOUNT, (Object)builder.build());
            return this;
        }

        public Builder cryptoDelete(CryptoDeleteTransactionBody cryptoDelete) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE, (Object)cryptoDelete);
            return this;
        }

        public Builder cryptoDelete(CryptoDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE, (Object)builder.build());
            return this;
        }

        public Builder cryptoDeleteLiveHash(CryptoDeleteLiveHashTransactionBody cryptoDeleteLiveHash) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE_LIVE_HASH, (Object)cryptoDeleteLiveHash);
            return this;
        }

        public Builder cryptoDeleteLiveHash(CryptoDeleteLiveHashTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_DELETE_LIVE_HASH, (Object)builder.build());
            return this;
        }

        public Builder cryptoTransfer(CryptoTransferTransactionBody cryptoTransfer) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_TRANSFER, (Object)cryptoTransfer);
            return this;
        }

        public Builder cryptoTransfer(CryptoTransferTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_TRANSFER, (Object)builder.build());
            return this;
        }

        public Builder cryptoUpdateAccount(CryptoUpdateTransactionBody cryptoUpdateAccount) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_UPDATE_ACCOUNT, (Object)cryptoUpdateAccount);
            return this;
        }

        public Builder cryptoUpdateAccount(CryptoUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CRYPTO_UPDATE_ACCOUNT, (Object)builder.build());
            return this;
        }

        public Builder fileAppend(FileAppendTransactionBody fileAppend) {
            this.data = new OneOf((Object)DataOneOfType.FILE_APPEND, (Object)fileAppend);
            return this;
        }

        public Builder fileAppend(FileAppendTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.FILE_APPEND, (Object)builder.build());
            return this;
        }

        public Builder fileCreate(FileCreateTransactionBody fileCreate) {
            this.data = new OneOf((Object)DataOneOfType.FILE_CREATE, (Object)fileCreate);
            return this;
        }

        public Builder fileCreate(FileCreateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.FILE_CREATE, (Object)builder.build());
            return this;
        }

        public Builder fileDelete(FileDeleteTransactionBody fileDelete) {
            this.data = new OneOf((Object)DataOneOfType.FILE_DELETE, (Object)fileDelete);
            return this;
        }

        public Builder fileDelete(FileDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.FILE_DELETE, (Object)builder.build());
            return this;
        }

        public Builder fileUpdate(FileUpdateTransactionBody fileUpdate) {
            this.data = new OneOf((Object)DataOneOfType.FILE_UPDATE, (Object)fileUpdate);
            return this;
        }

        public Builder fileUpdate(FileUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.FILE_UPDATE, (Object)builder.build());
            return this;
        }

        public Builder systemDelete(SystemDeleteTransactionBody systemDelete) {
            this.data = new OneOf((Object)DataOneOfType.SYSTEM_DELETE, (Object)systemDelete);
            return this;
        }

        public Builder systemDelete(SystemDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.SYSTEM_DELETE, (Object)builder.build());
            return this;
        }

        public Builder systemUndelete(SystemUndeleteTransactionBody systemUndelete) {
            this.data = new OneOf((Object)DataOneOfType.SYSTEM_UNDELETE, (Object)systemUndelete);
            return this;
        }

        public Builder systemUndelete(SystemUndeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.SYSTEM_UNDELETE, (Object)builder.build());
            return this;
        }

        public Builder freeze(FreezeTransactionBody freeze) {
            this.data = new OneOf((Object)DataOneOfType.FREEZE, (Object)freeze);
            return this;
        }

        public Builder freeze(FreezeTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.FREEZE, (Object)builder.build());
            return this;
        }

        public Builder consensusCreateTopic(ConsensusCreateTopicTransactionBody consensusCreateTopic) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_CREATE_TOPIC, (Object)consensusCreateTopic);
            return this;
        }

        public Builder consensusCreateTopic(ConsensusCreateTopicTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_CREATE_TOPIC, (Object)builder.build());
            return this;
        }

        public Builder consensusUpdateTopic(ConsensusUpdateTopicTransactionBody consensusUpdateTopic) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_UPDATE_TOPIC, (Object)consensusUpdateTopic);
            return this;
        }

        public Builder consensusUpdateTopic(ConsensusUpdateTopicTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_UPDATE_TOPIC, (Object)builder.build());
            return this;
        }

        public Builder consensusDeleteTopic(ConsensusDeleteTopicTransactionBody consensusDeleteTopic) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_DELETE_TOPIC, (Object)consensusDeleteTopic);
            return this;
        }

        public Builder consensusDeleteTopic(ConsensusDeleteTopicTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_DELETE_TOPIC, (Object)builder.build());
            return this;
        }

        public Builder consensusSubmitMessage(ConsensusSubmitMessageTransactionBody consensusSubmitMessage) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_SUBMIT_MESSAGE, (Object)consensusSubmitMessage);
            return this;
        }

        public Builder consensusSubmitMessage(ConsensusSubmitMessageTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.CONSENSUS_SUBMIT_MESSAGE, (Object)builder.build());
            return this;
        }

        public Builder uncheckedSubmit(UncheckedSubmitBody uncheckedSubmit) {
            this.data = new OneOf((Object)DataOneOfType.UNCHECKED_SUBMIT, (Object)uncheckedSubmit);
            return this;
        }

        public Builder uncheckedSubmit(UncheckedSubmitBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.UNCHECKED_SUBMIT, (Object)builder.build());
            return this;
        }

        public Builder tokenCreation(TokenCreateTransactionBody tokenCreation) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_CREATION, (Object)tokenCreation);
            return this;
        }

        public Builder tokenCreation(TokenCreateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_CREATION, (Object)builder.build());
            return this;
        }

        public Builder tokenFreeze(TokenFreezeAccountTransactionBody tokenFreeze) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_FREEZE, (Object)tokenFreeze);
            return this;
        }

        public Builder tokenFreeze(TokenFreezeAccountTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_FREEZE, (Object)builder.build());
            return this;
        }

        public Builder tokenUnfreeze(TokenUnfreezeAccountTransactionBody tokenUnfreeze) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UNFREEZE, (Object)tokenUnfreeze);
            return this;
        }

        public Builder tokenUnfreeze(TokenUnfreezeAccountTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UNFREEZE, (Object)builder.build());
            return this;
        }

        public Builder tokenGrantKyc(TokenGrantKycTransactionBody tokenGrantKyc) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_GRANT_KYC, (Object)tokenGrantKyc);
            return this;
        }

        public Builder tokenGrantKyc(TokenGrantKycTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_GRANT_KYC, (Object)builder.build());
            return this;
        }

        public Builder tokenRevokeKyc(TokenRevokeKycTransactionBody tokenRevokeKyc) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_REVOKE_KYC, (Object)tokenRevokeKyc);
            return this;
        }

        public Builder tokenRevokeKyc(TokenRevokeKycTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_REVOKE_KYC, (Object)builder.build());
            return this;
        }

        public Builder tokenDeletion(TokenDeleteTransactionBody tokenDeletion) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_DELETION, (Object)tokenDeletion);
            return this;
        }

        public Builder tokenDeletion(TokenDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_DELETION, (Object)builder.build());
            return this;
        }

        public Builder tokenUpdate(TokenUpdateTransactionBody tokenUpdate) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UPDATE, (Object)tokenUpdate);
            return this;
        }

        public Builder tokenUpdate(TokenUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UPDATE, (Object)builder.build());
            return this;
        }

        public Builder tokenMint(TokenMintTransactionBody tokenMint) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_MINT, (Object)tokenMint);
            return this;
        }

        public Builder tokenMint(TokenMintTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_MINT, (Object)builder.build());
            return this;
        }

        public Builder tokenBurn(TokenBurnTransactionBody tokenBurn) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_BURN, (Object)tokenBurn);
            return this;
        }

        public Builder tokenBurn(TokenBurnTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_BURN, (Object)builder.build());
            return this;
        }

        public Builder tokenWipe(TokenWipeAccountTransactionBody tokenWipe) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_WIPE, (Object)tokenWipe);
            return this;
        }

        public Builder tokenWipe(TokenWipeAccountTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_WIPE, (Object)builder.build());
            return this;
        }

        public Builder tokenAssociate(TokenAssociateTransactionBody tokenAssociate) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_ASSOCIATE, (Object)tokenAssociate);
            return this;
        }

        public Builder tokenAssociate(TokenAssociateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_ASSOCIATE, (Object)builder.build());
            return this;
        }

        public Builder tokenDissociate(TokenDissociateTransactionBody tokenDissociate) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_DISSOCIATE, (Object)tokenDissociate);
            return this;
        }

        public Builder tokenDissociate(TokenDissociateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_DISSOCIATE, (Object)builder.build());
            return this;
        }

        public Builder tokenFeeScheduleUpdate(TokenFeeScheduleUpdateTransactionBody tokenFeeScheduleUpdate) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE, (Object)tokenFeeScheduleUpdate);
            return this;
        }

        public Builder tokenFeeScheduleUpdate(TokenFeeScheduleUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_FEE_SCHEDULE_UPDATE, (Object)builder.build());
            return this;
        }

        public Builder tokenPause(TokenPauseTransactionBody tokenPause) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_PAUSE, (Object)tokenPause);
            return this;
        }

        public Builder tokenPause(TokenPauseTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_PAUSE, (Object)builder.build());
            return this;
        }

        public Builder tokenUnpause(TokenUnpauseTransactionBody tokenUnpause) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UNPAUSE, (Object)tokenUnpause);
            return this;
        }

        public Builder tokenUnpause(TokenUnpauseTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.TOKEN_UNPAUSE, (Object)builder.build());
            return this;
        }

        public Builder scheduleCreate(ScheduleCreateTransactionBody scheduleCreate) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_CREATE, (Object)scheduleCreate);
            return this;
        }

        public Builder scheduleCreate(ScheduleCreateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_CREATE, (Object)builder.build());
            return this;
        }

        public Builder scheduleDelete(ScheduleDeleteTransactionBody scheduleDelete) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_DELETE, (Object)scheduleDelete);
            return this;
        }

        public Builder scheduleDelete(ScheduleDeleteTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_DELETE, (Object)builder.build());
            return this;
        }

        public Builder scheduleSign(ScheduleSignTransactionBody scheduleSign) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_SIGN, (Object)scheduleSign);
            return this;
        }

        public Builder scheduleSign(ScheduleSignTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.SCHEDULE_SIGN, (Object)builder.build());
            return this;
        }

        public Builder nodeStakeUpdate(NodeStakeUpdateTransactionBody nodeStakeUpdate) {
            this.data = new OneOf((Object)DataOneOfType.NODE_STAKE_UPDATE, (Object)nodeStakeUpdate);
            return this;
        }

        public Builder nodeStakeUpdate(NodeStakeUpdateTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.NODE_STAKE_UPDATE, (Object)builder.build());
            return this;
        }

        public Builder utilPrng(UtilPrngTransactionBody utilPrng) {
            this.data = new OneOf((Object)DataOneOfType.UTIL_PRNG, (Object)utilPrng);
            return this;
        }

        public Builder utilPrng(UtilPrngTransactionBody.Builder builder) {
            this.data = new OneOf((Object)DataOneOfType.UTIL_PRNG, (Object)builder.build());
            return this;
        }
    }
}

