/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.codec.TransactionGetRecordQueryJsonCodec;
import com.hedera.hapi.node.transaction.codec.TransactionGetRecordQueryProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionGetRecordQuery(@Nullable QueryHeader header, @Nullable TransactionID transactionID, boolean includeDuplicates, boolean includeChildRecords) {
    public static final Codec<TransactionGetRecordQuery> PROTOBUF = new TransactionGetRecordQueryProtoCodec();
    public static final JsonCodec<TransactionGetRecordQuery> JSON = new TransactionGetRecordQueryJsonCodec();
    public static final TransactionGetRecordQuery DEFAULT = TransactionGetRecordQuery.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.header != null && !this.header.equals(TransactionGetRecordQuery.DEFAULT.header)) {
            result = 31 * result + this.header.hashCode();
        }
        if (this.transactionID != null && !this.transactionID.equals(TransactionGetRecordQuery.DEFAULT.transactionID)) {
            result = 31 * result + this.transactionID.hashCode();
        }
        if (this.includeDuplicates != TransactionGetRecordQuery.DEFAULT.includeDuplicates) {
            result = 31 * result + Boolean.hashCode(this.includeDuplicates);
        }
        if (this.includeChildRecords != TransactionGetRecordQuery.DEFAULT.includeChildRecords) {
            result = 31 * result + Boolean.hashCode(this.includeChildRecords);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionGetRecordQuery thatObj = (TransactionGetRecordQuery)that;
        if (this.header == null && thatObj.header != null) {
            return false;
        }
        if (this.header != null && !this.header.equals(thatObj.header)) {
            return false;
        }
        if (this.transactionID == null && thatObj.transactionID != null) {
            return false;
        }
        if (this.transactionID != null && !this.transactionID.equals(thatObj.transactionID)) {
            return false;
        }
        if (this.includeDuplicates != thatObj.includeDuplicates) {
            return false;
        }
        return this.includeChildRecords == thatObj.includeChildRecords;
    }

    public boolean hasHeader() {
        return this.header != null;
    }

    public QueryHeader headerOrElse(@NonNull QueryHeader defaultValue) {
        return this.hasHeader() ? this.header : defaultValue;
    }

    @NonNull
    public QueryHeader headerOrThrow() {
        return Objects.requireNonNull(this.header, "Field header is null");
    }

    public void ifHeader(@NonNull Consumer<QueryHeader> ifPresent) {
        if (this.hasHeader()) {
            ifPresent.accept(this.header);
        }
    }

    public boolean hasTransactionID() {
        return this.transactionID != null;
    }

    public TransactionID transactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasTransactionID() ? this.transactionID : defaultValue;
    }

    @NonNull
    public TransactionID transactionIDOrThrow() {
        return Objects.requireNonNull(this.transactionID, "Field transactionID is null");
    }

    public void ifTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasTransactionID()) {
            ifPresent.accept(this.transactionID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.header, this.transactionID, this.includeDuplicates, this.includeChildRecords);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private QueryHeader header = null;
        private TransactionID transactionID = null;
        private boolean includeDuplicates = false;
        private boolean includeChildRecords = false;

        public Builder() {
        }

        public Builder(QueryHeader header, TransactionID transactionID, boolean includeDuplicates, boolean includeChildRecords) {
            this.header = header;
            this.transactionID = transactionID;
            this.includeDuplicates = includeDuplicates;
            this.includeChildRecords = includeChildRecords;
        }

        public TransactionGetRecordQuery build() {
            return new TransactionGetRecordQuery(this.header, this.transactionID, this.includeDuplicates, this.includeChildRecords);
        }

        public Builder header(QueryHeader header) {
            this.header = header;
            return this;
        }

        public Builder header(QueryHeader.Builder builder) {
            this.header = builder.build();
            return this;
        }

        public Builder transactionID(TransactionID transactionID) {
            this.transactionID = transactionID;
            return this;
        }

        public Builder transactionID(TransactionID.Builder builder) {
            this.transactionID = builder.build();
            return this;
        }

        public Builder includeDuplicates(boolean includeDuplicates) {
            this.includeDuplicates = includeDuplicates;
            return this;
        }

        public Builder includeChildRecords(boolean includeChildRecords) {
            this.includeChildRecords = includeChildRecords;
            return this;
        }
    }
}

