/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.codec.TransactionReceiptJsonCodec;
import com.hedera.hapi.node.transaction.codec.TransactionReceiptProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionReceipt(ResponseCodeEnum status, @Nullable AccountID accountID, @Nullable FileID fileID, @Nullable ContractID contractID, @Nullable ExchangeRateSet exchangeRate, @Nullable TopicID topicID, long topicSequenceNumber, Bytes topicRunningHash, long topicRunningHashVersion, @Nullable TokenID tokenID, long newTotalSupply, @Nullable ScheduleID scheduleID, @Nullable TransactionID scheduledTransactionID, List<Long> serialNumbers) {
    public static final Codec<TransactionReceipt> PROTOBUF = new TransactionReceiptProtoCodec();
    public static final JsonCodec<TransactionReceipt> JSON = new TransactionReceiptJsonCodec();
    public static final TransactionReceipt DEFAULT = TransactionReceipt.newBuilder().build();

    @Override
    public int hashCode() {
        List<Long> list$serialNumbers;
        int result = 1;
        if (this.status != null && !this.status.equals((Object)TransactionReceipt.DEFAULT.status)) {
            result = 31 * result + this.status.hashCode();
        }
        if (this.accountID != null && !this.accountID.equals(TransactionReceipt.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.fileID != null && !this.fileID.equals(TransactionReceipt.DEFAULT.fileID)) {
            result = 31 * result + this.fileID.hashCode();
        }
        if (this.contractID != null && !this.contractID.equals(TransactionReceipt.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.exchangeRate != null && !this.exchangeRate.equals(TransactionReceipt.DEFAULT.exchangeRate)) {
            result = 31 * result + this.exchangeRate.hashCode();
        }
        if (this.topicID != null && !this.topicID.equals(TransactionReceipt.DEFAULT.topicID)) {
            result = 31 * result + this.topicID.hashCode();
        }
        if (this.topicSequenceNumber != TransactionReceipt.DEFAULT.topicSequenceNumber) {
            result = 31 * result + Long.hashCode(this.topicSequenceNumber);
        }
        if (this.topicRunningHash != null && !this.topicRunningHash.equals((Object)TransactionReceipt.DEFAULT.topicRunningHash)) {
            result = 31 * result + this.topicRunningHash.hashCode();
        }
        if (this.topicRunningHashVersion != TransactionReceipt.DEFAULT.topicRunningHashVersion) {
            result = 31 * result + Long.hashCode(this.topicRunningHashVersion);
        }
        if (this.tokenID != null && !this.tokenID.equals(TransactionReceipt.DEFAULT.tokenID)) {
            result = 31 * result + this.tokenID.hashCode();
        }
        if (this.newTotalSupply != TransactionReceipt.DEFAULT.newTotalSupply) {
            result = 31 * result + Long.hashCode(this.newTotalSupply);
        }
        if (this.scheduleID != null && !this.scheduleID.equals(TransactionReceipt.DEFAULT.scheduleID)) {
            result = 31 * result + this.scheduleID.hashCode();
        }
        if (this.scheduledTransactionID != null && !this.scheduledTransactionID.equals(TransactionReceipt.DEFAULT.scheduledTransactionID)) {
            result = 31 * result + this.scheduledTransactionID.hashCode();
        }
        if ((list$serialNumbers = this.serialNumbers) != null) {
            for (Long o : list$serialNumbers) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionReceipt thatObj = (TransactionReceipt)that;
        if (this.status == null && thatObj.status != null) {
            return false;
        }
        if (this.status != null && !this.status.equals((Object)thatObj.status)) {
            return false;
        }
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.fileID == null && thatObj.fileID != null) {
            return false;
        }
        if (this.fileID != null && !this.fileID.equals(thatObj.fileID)) {
            return false;
        }
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.exchangeRate == null && thatObj.exchangeRate != null) {
            return false;
        }
        if (this.exchangeRate != null && !this.exchangeRate.equals(thatObj.exchangeRate)) {
            return false;
        }
        if (this.topicID == null && thatObj.topicID != null) {
            return false;
        }
        if (this.topicID != null && !this.topicID.equals(thatObj.topicID)) {
            return false;
        }
        if (this.topicSequenceNumber != thatObj.topicSequenceNumber) {
            return false;
        }
        if (this.topicRunningHash == null && thatObj.topicRunningHash != null) {
            return false;
        }
        if (this.topicRunningHash != null && !this.topicRunningHash.equals((Object)thatObj.topicRunningHash)) {
            return false;
        }
        if (this.topicRunningHashVersion != thatObj.topicRunningHashVersion) {
            return false;
        }
        if (this.tokenID == null && thatObj.tokenID != null) {
            return false;
        }
        if (this.tokenID != null && !this.tokenID.equals(thatObj.tokenID)) {
            return false;
        }
        if (this.newTotalSupply != thatObj.newTotalSupply) {
            return false;
        }
        if (this.scheduleID == null && thatObj.scheduleID != null) {
            return false;
        }
        if (this.scheduleID != null && !this.scheduleID.equals(thatObj.scheduleID)) {
            return false;
        }
        if (this.scheduledTransactionID == null && thatObj.scheduledTransactionID != null) {
            return false;
        }
        if (this.scheduledTransactionID != null && !this.scheduledTransactionID.equals(thatObj.scheduledTransactionID)) {
            return false;
        }
        if (this.serialNumbers == null && thatObj.serialNumbers != null) {
            return false;
        }
        return this.serialNumbers == null || this.serialNumbers.equals(thatObj.serialNumbers);
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasExchangeRate() {
        return this.exchangeRate != null;
    }

    public ExchangeRateSet exchangeRateOrElse(@NonNull ExchangeRateSet defaultValue) {
        return this.hasExchangeRate() ? this.exchangeRate : defaultValue;
    }

    @NonNull
    public ExchangeRateSet exchangeRateOrThrow() {
        return Objects.requireNonNull(this.exchangeRate, "Field exchangeRate is null");
    }

    public void ifExchangeRate(@NonNull Consumer<ExchangeRateSet> ifPresent) {
        if (this.hasExchangeRate()) {
            ifPresent.accept(this.exchangeRate);
        }
    }

    public boolean hasTopicID() {
        return this.topicID != null;
    }

    public TopicID topicIDOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicID() ? this.topicID : defaultValue;
    }

    @NonNull
    public TopicID topicIDOrThrow() {
        return Objects.requireNonNull(this.topicID, "Field topicID is null");
    }

    public void ifTopicID(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicID()) {
            ifPresent.accept(this.topicID);
        }
    }

    public boolean hasTokenID() {
        return this.tokenID != null;
    }

    public TokenID tokenIDOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenID() ? this.tokenID : defaultValue;
    }

    @NonNull
    public TokenID tokenIDOrThrow() {
        return Objects.requireNonNull(this.tokenID, "Field tokenID is null");
    }

    public void ifTokenID(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenID()) {
            ifPresent.accept(this.tokenID);
        }
    }

    public boolean hasScheduleID() {
        return this.scheduleID != null;
    }

    public ScheduleID scheduleIDOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleID() ? this.scheduleID : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleIDOrThrow() {
        return Objects.requireNonNull(this.scheduleID, "Field scheduleID is null");
    }

    public void ifScheduleID(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleID()) {
            ifPresent.accept(this.scheduleID);
        }
    }

    public boolean hasScheduledTransactionID() {
        return this.scheduledTransactionID != null;
    }

    public TransactionID scheduledTransactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasScheduledTransactionID() ? this.scheduledTransactionID : defaultValue;
    }

    @NonNull
    public TransactionID scheduledTransactionIDOrThrow() {
        return Objects.requireNonNull(this.scheduledTransactionID, "Field scheduledTransactionID is null");
    }

    public void ifScheduledTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasScheduledTransactionID()) {
            ifPresent.accept(this.scheduledTransactionID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.status, this.accountID, this.fileID, this.contractID, this.exchangeRate, this.topicID, this.topicSequenceNumber, this.topicRunningHash, this.topicRunningHashVersion, this.tokenID, this.newTotalSupply, this.scheduleID, this.scheduledTransactionID, this.serialNumbers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ResponseCodeEnum status = ResponseCodeEnum.values()[0];
        private AccountID accountID = null;
        private FileID fileID = null;
        private ContractID contractID = null;
        private ExchangeRateSet exchangeRate = null;
        private TopicID topicID = null;
        private long topicSequenceNumber = 0L;
        private Bytes topicRunningHash = Bytes.EMPTY;
        private long topicRunningHashVersion = 0L;
        private TokenID tokenID = null;
        private long newTotalSupply = 0L;
        private ScheduleID scheduleID = null;
        private TransactionID scheduledTransactionID = null;
        private List<Long> serialNumbers = Collections.emptyList();

        public Builder() {
        }

        public Builder(ResponseCodeEnum status, AccountID accountID, FileID fileID, ContractID contractID, ExchangeRateSet exchangeRate, TopicID topicID, long topicSequenceNumber, Bytes topicRunningHash, long topicRunningHashVersion, TokenID tokenID, long newTotalSupply, ScheduleID scheduleID, TransactionID scheduledTransactionID, List<Long> serialNumbers) {
            this.status = status;
            this.accountID = accountID;
            this.fileID = fileID;
            this.contractID = contractID;
            this.exchangeRate = exchangeRate;
            this.topicID = topicID;
            this.topicSequenceNumber = topicSequenceNumber;
            this.topicRunningHash = topicRunningHash;
            this.topicRunningHashVersion = topicRunningHashVersion;
            this.tokenID = tokenID;
            this.newTotalSupply = newTotalSupply;
            this.scheduleID = scheduleID;
            this.scheduledTransactionID = scheduledTransactionID;
            this.serialNumbers = serialNumbers;
        }

        public TransactionReceipt build() {
            return new TransactionReceipt(this.status, this.accountID, this.fileID, this.contractID, this.exchangeRate, this.topicID, this.topicSequenceNumber, this.topicRunningHash, this.topicRunningHashVersion, this.tokenID, this.newTotalSupply, this.scheduleID, this.scheduledTransactionID, this.serialNumbers);
        }

        public Builder status(ResponseCodeEnum status) {
            this.status = status;
            return this;
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder contractID(ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder exchangeRate(ExchangeRateSet exchangeRate) {
            this.exchangeRate = exchangeRate;
            return this;
        }

        public Builder exchangeRate(ExchangeRateSet.Builder builder) {
            this.exchangeRate = builder.build();
            return this;
        }

        public Builder topicID(TopicID topicID) {
            this.topicID = topicID;
            return this;
        }

        public Builder topicID(TopicID.Builder builder) {
            this.topicID = builder.build();
            return this;
        }

        public Builder topicSequenceNumber(long topicSequenceNumber) {
            this.topicSequenceNumber = topicSequenceNumber;
            return this;
        }

        public Builder topicRunningHash(Bytes topicRunningHash) {
            this.topicRunningHash = topicRunningHash;
            return this;
        }

        public Builder topicRunningHashVersion(long topicRunningHashVersion) {
            this.topicRunningHashVersion = topicRunningHashVersion;
            return this;
        }

        public Builder tokenID(TokenID tokenID) {
            this.tokenID = tokenID;
            return this;
        }

        public Builder tokenID(TokenID.Builder builder) {
            this.tokenID = builder.build();
            return this;
        }

        public Builder newTotalSupply(long newTotalSupply) {
            this.newTotalSupply = newTotalSupply;
            return this;
        }

        public Builder scheduleID(ScheduleID scheduleID) {
            this.scheduleID = scheduleID;
            return this;
        }

        public Builder scheduleID(ScheduleID.Builder builder) {
            this.scheduleID = builder.build();
            return this;
        }

        public Builder scheduledTransactionID(TransactionID scheduledTransactionID) {
            this.scheduledTransactionID = scheduledTransactionID;
            return this;
        }

        public Builder scheduledTransactionID(TransactionID.Builder builder) {
            this.scheduledTransactionID = builder.build();
            return this;
        }

        public Builder serialNumbers(List<Long> serialNumbers) {
            this.serialNumbers = serialNumbers;
            return this;
        }

        public Builder serialNumbers(Long ... values) {
            this.serialNumbers = List.of(values);
            return this;
        }
    }
}

