/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.codec.ContractBytecodeJsonCodec;
import com.hedera.hapi.streams.codec.ContractBytecodeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractBytecode(@Nullable ContractID contractId, Bytes initcode, Bytes runtimeBytecode) {
    public static final Codec<ContractBytecode> PROTOBUF = new ContractBytecodeProtoCodec();
    public static final JsonCodec<ContractBytecode> JSON = new ContractBytecodeJsonCodec();
    public static final ContractBytecode DEFAULT = ContractBytecode.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.contractId != null && !this.contractId.equals(ContractBytecode.DEFAULT.contractId)) {
            result = 31 * result + this.contractId.hashCode();
        }
        if (this.initcode != null && !this.initcode.equals((Object)ContractBytecode.DEFAULT.initcode)) {
            result = 31 * result + this.initcode.hashCode();
        }
        if (this.runtimeBytecode != null && !this.runtimeBytecode.equals((Object)ContractBytecode.DEFAULT.runtimeBytecode)) {
            result = 31 * result + this.runtimeBytecode.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractBytecode thatObj = (ContractBytecode)that;
        if (this.contractId == null && thatObj.contractId != null) {
            return false;
        }
        if (this.contractId != null && !this.contractId.equals(thatObj.contractId)) {
            return false;
        }
        if (this.initcode == null && thatObj.initcode != null) {
            return false;
        }
        if (this.initcode != null && !this.initcode.equals((Object)thatObj.initcode)) {
            return false;
        }
        if (this.runtimeBytecode == null && thatObj.runtimeBytecode != null) {
            return false;
        }
        return this.runtimeBytecode == null || this.runtimeBytecode.equals((Object)thatObj.runtimeBytecode);
    }

    public boolean hasContractId() {
        return this.contractId != null;
    }

    public ContractID contractIdOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractId() ? this.contractId : defaultValue;
    }

    @NonNull
    public ContractID contractIdOrThrow() {
        return Objects.requireNonNull(this.contractId, "Field contractId is null");
    }

    public void ifContractId(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractId()) {
            ifPresent.accept(this.contractId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractId, this.initcode, this.runtimeBytecode);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ContractID contractId = null;
        private Bytes initcode = Bytes.EMPTY;
        private Bytes runtimeBytecode = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(ContractID contractId, Bytes initcode, Bytes runtimeBytecode) {
            this.contractId = contractId;
            this.initcode = initcode;
            this.runtimeBytecode = runtimeBytecode;
        }

        public ContractBytecode build() {
            return new ContractBytecode(this.contractId, this.initcode, this.runtimeBytecode);
        }

        public Builder contractId(ContractID contractId) {
            this.contractId = contractId;
            return this;
        }

        public Builder contractId(ContractID.Builder builder) {
            this.contractId = builder.build();
            return this;
        }

        public Builder initcode(Bytes initcode) {
            this.initcode = initcode;
            return this;
        }

        public Builder runtimeBytecode(Bytes runtimeBytecode) {
            this.runtimeBytecode = runtimeBytecode;
            return this;
        }
    }
}

