/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SidecarMetadata;
import com.hedera.hapi.streams.SidecarType;
import com.hedera.hapi.streams.schema.SidecarMetadataSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.List;

public final class SidecarMetadataProtoCodec
implements Codec<SidecarMetadata> {
    @NonNull
    public SidecarMetadata parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SidecarMetadata parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SidecarMetadata data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SidecarMetadataSchema.HASH, (Object)data.hash(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SidecarMetadataSchema.ID, (int)data.id());
        ProtoWriterTools.writeEnumList((WritableSequentialData)out, (FieldDefinition)SidecarMetadataSchema.TYPES, data.types());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SidecarMetadata data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SidecarMetadataSchema.HASH, (Object)data.hash(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SidecarMetadataSchema.ID, (int)data.id());
        return size += ProtoWriterTools.sizeOfEnumList((FieldDefinition)SidecarMetadataSchema.TYPES, data.types());
    }

    public boolean fastEquals(@NonNull SidecarMetadata item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SidecarMetadata parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        temp_hash = null;
        temp_id = 0;
        temp_types = Collections.emptyList();
        try {
            block11: while (input.hasRemaining() != false) {
                tag = input.readVarInt(false);
                field = tag >>> 3;
                f = SidecarMetadataSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl15
                        value = HashObject.DEFAULT;
                        ** GOTO lbl28
lbl15:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl28:
                        // 2 sources

                        temp_hash = value;
                        continue block11;
                    }
                    case 16: {
                        temp_id = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 24: {
                        value = SidecarType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        temp_types = ProtoParserTools.addToList(temp_types, (Object)value);
                        continue block11;
                    }
                    case 26: {
                        length = input.readVarInt(false);
                        beforeLimit = input.limit();
                        input.limit(input.position() + (long)length);
                        while (input.hasRemaining()) {
                            temp_types = ProtoParserTools.addToList((List)temp_types, (Object)SidecarType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input)));
                        }
                        input.limit(beforeLimit);
                        continue block11;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new SidecarMetadata(temp_hash, temp_id, temp_types);
        }
        catch (EOFException var6_7) {
            // empty catch block
        }
        return new SidecarMetadata(temp_hash, temp_id, temp_types);
    }
}

