/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.StorageChange;
import com.hedera.hapi.streams.schema.StorageChangeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class StorageChangeProtoCodec
implements Codec<StorageChange> {
    @NonNull
    public StorageChange parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public StorageChange parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull StorageChange data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)StorageChangeSchema.SLOT, (RandomAccessData)data.slot());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)StorageChangeSchema.VALUE_READ, (RandomAccessData)data.valueRead());
        ProtoWriterTools.writeOptionalBytes((WritableSequentialData)out, (FieldDefinition)StorageChangeSchema.VALUE_WRITTEN, (Bytes)data.valueWritten());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(StorageChange data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)StorageChangeSchema.SLOT, (RandomAccessData)data.slot());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)StorageChangeSchema.VALUE_READ, (RandomAccessData)data.valueRead());
        return size += ProtoWriterTools.sizeOfOptionalBytes((FieldDefinition)StorageChangeSchema.VALUE_WRITTEN, (RandomAccessData)data.valueWritten());
    }

    public boolean fastEquals(@NonNull StorageChange item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private StorageChange parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Bytes temp_slot = Bytes.EMPTY;
        Bytes temp_value_read = Bytes.EMPTY;
        Bytes temp_value_written = null;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = StorageChangeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_slot = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 18: {
                        Bytes value;
                        temp_value_read = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        Bytes value;
                        int valueTypeMessageSize = input.readVarInt(false);
                        if (valueTypeMessageSize > 0) {
                            long beforeLimit = input.limit();
                            input.limit(input.position() + (long)valueTypeMessageSize);
                            int valueFieldTag = input.readVarInt(false);
                            assert (valueFieldTag >>> 3 == 1);
                            assert ((valueFieldTag & 7) == 2);
                            value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                            input.limit(beforeLimit);
                        } else {
                            value = Bytes.EMPTY;
                        }
                        temp_value_written = value;
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
            }
            return new StorageChange(temp_slot, temp_value_read, temp_value_written);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new StorageChange(temp_slot, temp_value_read, temp_value_written);
    }
}

