/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.codec.AccountAmountJsonCodec;
import com.hedera.hapi.node.base.codec.AccountAmountProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountAmount(@Nullable AccountID accountID, long amount, boolean isApproval) {
    public static final Codec<AccountAmount> PROTOBUF = new AccountAmountProtoCodec();
    public static final JsonCodec<AccountAmount> JSON = new AccountAmountJsonCodec();
    public static final AccountAmount DEFAULT = AccountAmount.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.accountID != null && !this.accountID.equals(AccountAmount.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.amount != AccountAmount.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        if (this.isApproval != AccountAmount.DEFAULT.isApproval) {
            result = 31 * result + Boolean.hashCode(this.isApproval);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AccountAmount thatObj = (AccountAmount)that;
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        return this.isApproval == thatObj.isApproval;
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.amount, this.isApproval);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID accountID = null;
        private long amount = 0L;
        private boolean isApproval = false;

        public Builder() {
        }

        public Builder(AccountID accountID, long amount, boolean isApproval) {
            this.accountID = accountID;
            this.amount = amount;
            this.isApproval = isApproval;
        }

        public AccountAmount build() {
            return new AccountAmount(this.accountID, this.amount, this.isApproval);
        }

        public Builder accountID(@Nullable AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }
    }
}

