/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.codec.FeeDataJsonCodec;
import com.hedera.hapi.node.base.codec.FeeDataProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FeeData(@Nullable FeeComponents nodedata, @Nullable FeeComponents networkdata, @Nullable FeeComponents servicedata, SubType subType) {
    public static final Codec<FeeData> PROTOBUF = new FeeDataProtoCodec();
    public static final JsonCodec<FeeData> JSON = new FeeDataJsonCodec();
    public static final FeeData DEFAULT = FeeData.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.nodedata != null && !this.nodedata.equals(FeeData.DEFAULT.nodedata)) {
            result = 31 * result + this.nodedata.hashCode();
        }
        if (this.networkdata != null && !this.networkdata.equals(FeeData.DEFAULT.networkdata)) {
            result = 31 * result + this.networkdata.hashCode();
        }
        if (this.servicedata != null && !this.servicedata.equals(FeeData.DEFAULT.servicedata)) {
            result = 31 * result + this.servicedata.hashCode();
        }
        if (this.subType != null && !this.subType.equals((Object)FeeData.DEFAULT.subType)) {
            result = 31 * result + this.subType.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FeeData thatObj = (FeeData)that;
        if (this.nodedata == null && thatObj.nodedata != null) {
            return false;
        }
        if (this.nodedata != null && !this.nodedata.equals(thatObj.nodedata)) {
            return false;
        }
        if (this.networkdata == null && thatObj.networkdata != null) {
            return false;
        }
        if (this.networkdata != null && !this.networkdata.equals(thatObj.networkdata)) {
            return false;
        }
        if (this.servicedata == null && thatObj.servicedata != null) {
            return false;
        }
        if (this.servicedata != null && !this.servicedata.equals(thatObj.servicedata)) {
            return false;
        }
        if (this.subType == null && thatObj.subType != null) {
            return false;
        }
        return this.subType == null || this.subType.equals((Object)thatObj.subType);
    }

    public boolean hasNodedata() {
        return this.nodedata != null;
    }

    public FeeComponents nodedataOrElse(@NonNull FeeComponents defaultValue) {
        return this.hasNodedata() ? this.nodedata : defaultValue;
    }

    @NonNull
    public FeeComponents nodedataOrThrow() {
        return Objects.requireNonNull(this.nodedata, "Field nodedata is null");
    }

    public void ifNodedata(@NonNull Consumer<FeeComponents> ifPresent) {
        if (this.hasNodedata()) {
            ifPresent.accept(this.nodedata);
        }
    }

    public boolean hasNetworkdata() {
        return this.networkdata != null;
    }

    public FeeComponents networkdataOrElse(@NonNull FeeComponents defaultValue) {
        return this.hasNetworkdata() ? this.networkdata : defaultValue;
    }

    @NonNull
    public FeeComponents networkdataOrThrow() {
        return Objects.requireNonNull(this.networkdata, "Field networkdata is null");
    }

    public void ifNetworkdata(@NonNull Consumer<FeeComponents> ifPresent) {
        if (this.hasNetworkdata()) {
            ifPresent.accept(this.networkdata);
        }
    }

    public boolean hasServicedata() {
        return this.servicedata != null;
    }

    public FeeComponents servicedataOrElse(@NonNull FeeComponents defaultValue) {
        return this.hasServicedata() ? this.servicedata : defaultValue;
    }

    @NonNull
    public FeeComponents servicedataOrThrow() {
        return Objects.requireNonNull(this.servicedata, "Field servicedata is null");
    }

    public void ifServicedata(@NonNull Consumer<FeeComponents> ifPresent) {
        if (this.hasServicedata()) {
            ifPresent.accept(this.servicedata);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nodedata, this.networkdata, this.servicedata, this.subType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private FeeComponents nodedata = null;
        @Nullable
        private FeeComponents networkdata = null;
        @Nullable
        private FeeComponents servicedata = null;
        private SubType subType = SubType.values()[0];

        public Builder() {
        }

        public Builder(FeeComponents nodedata, FeeComponents networkdata, FeeComponents servicedata, SubType subType) {
            this.nodedata = nodedata;
            this.networkdata = networkdata;
            this.servicedata = servicedata;
            this.subType = subType;
        }

        public FeeData build() {
            return new FeeData(this.nodedata, this.networkdata, this.servicedata, this.subType);
        }

        public Builder nodedata(@Nullable FeeComponents nodedata) {
            this.nodedata = nodedata;
            return this;
        }

        public Builder nodedata(FeeComponents.Builder builder) {
            this.nodedata = builder.build();
            return this;
        }

        public Builder networkdata(@Nullable FeeComponents networkdata) {
            this.networkdata = networkdata;
            return this;
        }

        public Builder networkdata(FeeComponents.Builder builder) {
            this.networkdata = builder.build();
            return this;
        }

        public Builder servicedata(@Nullable FeeComponents servicedata) {
            this.servicedata = servicedata;
            return this;
        }

        public Builder servicedata(FeeComponents.Builder builder) {
            this.servicedata = builder.build();
            return this;
        }

        public Builder subType(SubType subType) {
            this.subType = subType;
            return this;
        }
    }
}

