/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.FileIDJsonCodec;
import com.hedera.hapi.node.base.codec.FileIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;

public record FileID(long shardNum, long realmNum, long fileNum) {
    public static final Codec<FileID> PROTOBUF = new FileIDProtoCodec();
    public static final JsonCodec<FileID> JSON = new FileIDJsonCodec();
    public static final FileID DEFAULT = FileID.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.shardNum != FileID.DEFAULT.shardNum) {
            result = 31 * result + Long.hashCode(this.shardNum);
        }
        if (this.realmNum != FileID.DEFAULT.realmNum) {
            result = 31 * result + Long.hashCode(this.realmNum);
        }
        if (this.fileNum != FileID.DEFAULT.fileNum) {
            result = 31 * result + Long.hashCode(this.fileNum);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FileID thatObj = (FileID)that;
        if (this.shardNum != thatObj.shardNum) {
            return false;
        }
        if (this.realmNum != thatObj.realmNum) {
            return false;
        }
        return this.fileNum == thatObj.fileNum;
    }

    public Builder copyBuilder() {
        return new Builder(this.shardNum, this.realmNum, this.fileNum);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long shardNum = 0L;
        private long realmNum = 0L;
        private long fileNum = 0L;

        public Builder() {
        }

        public Builder(long shardNum, long realmNum, long fileNum) {
            this.shardNum = shardNum;
            this.realmNum = realmNum;
            this.fileNum = fileNum;
        }

        public FileID build() {
            return new FileID(this.shardNum, this.realmNum, this.fileNum);
        }

        public Builder shardNum(long shardNum) {
            this.shardNum = shardNum;
            return this;
        }

        public Builder realmNum(long realmNum) {
            this.realmNum = realmNum;
            return this;
        }

        public Builder fileNum(long fileNum) {
            this.fileNum = fileNum;
            return this;
        }
    }
}

