/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.hapi.node.base.codec.KeyJsonCodec;
import com.hedera.hapi.node.base.codec.KeyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record Key(OneOf<KeyOneOfType> key) {
    public static final Codec<Key> PROTOBUF = new KeyProtoCodec();
    public static final JsonCodec<Key> JSON = new KeyJsonCodec();
    public static final Key DEFAULT = Key.newBuilder().build();

    public Key {
        if (key == null) {
            throw new NullPointerException("Parameter 'key' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.key != null && !this.key.equals(Key.DEFAULT.key)) {
            result = 31 * result + this.key.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Key thatObj = (Key)that;
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        return this.key == null || this.key.equals(thatObj.key);
    }

    @Nullable
    public ContractID contractID() {
        return this.key.kind() == KeyOneOfType.CONTRACT_ID ? (ContractID)this.key.value() : null;
    }

    public boolean hasContractID() {
        return this.key.kind() == KeyOneOfType.CONTRACT_ID;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID() : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID(), "Field contractID is null");
    }

    @Nullable
    public Bytes ed25519() {
        return this.key.kind() == KeyOneOfType.ED25519 ? (Bytes)this.key.value() : null;
    }

    public boolean hasEd25519() {
        return this.key.kind() == KeyOneOfType.ED25519;
    }

    public Bytes ed25519OrElse(@NonNull Bytes defaultValue) {
        return this.hasEd25519() ? this.ed25519() : defaultValue;
    }

    @NonNull
    public Bytes ed25519OrThrow() {
        return Objects.requireNonNull(this.ed25519(), "Field ed25519 is null");
    }

    @Nullable
    public Bytes rsa3072() {
        return this.key.kind() == KeyOneOfType.RSA_3072 ? (Bytes)this.key.value() : null;
    }

    public boolean hasRsa3072() {
        return this.key.kind() == KeyOneOfType.RSA_3072;
    }

    public Bytes rsa3072OrElse(@NonNull Bytes defaultValue) {
        return this.hasRsa3072() ? this.rsa3072() : defaultValue;
    }

    @NonNull
    public Bytes rsa3072OrThrow() {
        return Objects.requireNonNull(this.rsa3072(), "Field rsa3072 is null");
    }

    @Nullable
    public Bytes ecdsa384() {
        return this.key.kind() == KeyOneOfType.ECDSA_384 ? (Bytes)this.key.value() : null;
    }

    public boolean hasEcdsa384() {
        return this.key.kind() == KeyOneOfType.ECDSA_384;
    }

    public Bytes ecdsa384OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsa384() ? this.ecdsa384() : defaultValue;
    }

    @NonNull
    public Bytes ecdsa384OrThrow() {
        return Objects.requireNonNull(this.ecdsa384(), "Field ecdsa384 is null");
    }

    @Nullable
    public ThresholdKey thresholdKey() {
        return this.key.kind() == KeyOneOfType.THRESHOLD_KEY ? (ThresholdKey)this.key.value() : null;
    }

    public boolean hasThresholdKey() {
        return this.key.kind() == KeyOneOfType.THRESHOLD_KEY;
    }

    public ThresholdKey thresholdKeyOrElse(@NonNull ThresholdKey defaultValue) {
        return this.hasThresholdKey() ? this.thresholdKey() : defaultValue;
    }

    @NonNull
    public ThresholdKey thresholdKeyOrThrow() {
        return Objects.requireNonNull(this.thresholdKey(), "Field thresholdKey is null");
    }

    @Nullable
    public KeyList keyList() {
        return this.key.kind() == KeyOneOfType.KEY_LIST ? (KeyList)this.key.value() : null;
    }

    public boolean hasKeyList() {
        return this.key.kind() == KeyOneOfType.KEY_LIST;
    }

    public KeyList keyListOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeyList() ? this.keyList() : defaultValue;
    }

    @NonNull
    public KeyList keyListOrThrow() {
        return Objects.requireNonNull(this.keyList(), "Field keyList is null");
    }

    @Nullable
    public Bytes ecdsaSecp256k1() {
        return this.key.kind() == KeyOneOfType.ECDSA_SECP256K1 ? (Bytes)this.key.value() : null;
    }

    public boolean hasEcdsaSecp256k1() {
        return this.key.kind() == KeyOneOfType.ECDSA_SECP256K1;
    }

    public Bytes ecdsaSecp256k1OrElse(@NonNull Bytes defaultValue) {
        return this.hasEcdsaSecp256k1() ? this.ecdsaSecp256k1() : defaultValue;
    }

    @NonNull
    public Bytes ecdsaSecp256k1OrThrow() {
        return Objects.requireNonNull(this.ecdsaSecp256k1(), "Field ecdsaSecp256k1 is null");
    }

    @Nullable
    public ContractID delegatableContractId() {
        return this.key.kind() == KeyOneOfType.DELEGATABLE_CONTRACT_ID ? (ContractID)this.key.value() : null;
    }

    public boolean hasDelegatableContractId() {
        return this.key.kind() == KeyOneOfType.DELEGATABLE_CONTRACT_ID;
    }

    public ContractID delegatableContractIdOrElse(@NonNull ContractID defaultValue) {
        return this.hasDelegatableContractId() ? this.delegatableContractId() : defaultValue;
    }

    @NonNull
    public ContractID delegatableContractIdOrThrow() {
        return Objects.requireNonNull(this.delegatableContractId(), "Field delegatableContractId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.key);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum KeyOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        CONTRACT_ID(1, "contractID"),
        ED25519(2, "ed25519"),
        RSA_3072(3, "RSA_3072"),
        ECDSA_384(4, "ECDSA_384"),
        THRESHOLD_KEY(5, "thresholdKey"),
        KEY_LIST(6, "keyList"),
        ECDSA_SECP256K1(7, "ECDSA_secp256k1"),
        DELEGATABLE_CONTRACT_ID(8, "delegatable_contract_id");

        private final int protoOrdinal;
        private final String protoName;

        private KeyOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static KeyOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> CONTRACT_ID;
                case 2 -> ED25519;
                case 3 -> RSA_3072;
                case 4 -> ECDSA_384;
                case 5 -> THRESHOLD_KEY;
                case 6 -> KEY_LIST;
                case 7 -> ECDSA_SECP256K1;
                case 8 -> DELEGATABLE_CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static KeyOneOfType fromString(String name) {
            return switch (name) {
                case "contractID", "CONTRACT_ID" -> CONTRACT_ID;
                case "ed25519", "ED25519" -> ED25519;
                case "RSA_3072" -> RSA_3072;
                case "ECDSA_384" -> ECDSA_384;
                case "thresholdKey", "THRESHOLD_KEY" -> THRESHOLD_KEY;
                case "keyList", "KEY_LIST" -> KEY_LIST;
                case "ECDSA_secp256k1", "ECDSA_SECP256K1" -> ECDSA_SECP256K1;
                case "delegatable_contract_id", "DELEGATABLE_CONTRACT_ID" -> DELEGATABLE_CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<KeyOneOfType> key = KeyProtoCodec.KEY_UNSET;

        public Builder() {
        }

        public Builder(OneOf<KeyOneOfType> key) {
            this.key = key;
        }

        public Key build() {
            return new Key(this.key);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.key = new OneOf((Enum)KeyOneOfType.CONTRACT_ID, (Object)contractID);
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.key = new OneOf((Enum)KeyOneOfType.CONTRACT_ID, (Object)builder.build());
            return this;
        }

        public Builder ed25519(@NonNull Bytes ed25519) {
            this.key = new OneOf((Enum)KeyOneOfType.ED25519, (Object)ed25519);
            return this;
        }

        public Builder rsa3072(@NonNull Bytes rsa3072) {
            this.key = new OneOf((Enum)KeyOneOfType.RSA_3072, (Object)rsa3072);
            return this;
        }

        public Builder ecdsa384(@NonNull Bytes ecdsa384) {
            this.key = new OneOf((Enum)KeyOneOfType.ECDSA_384, (Object)ecdsa384);
            return this;
        }

        public Builder thresholdKey(@Nullable ThresholdKey thresholdKey) {
            this.key = new OneOf((Enum)KeyOneOfType.THRESHOLD_KEY, (Object)thresholdKey);
            return this;
        }

        public Builder thresholdKey(ThresholdKey.Builder builder) {
            this.key = new OneOf((Enum)KeyOneOfType.THRESHOLD_KEY, (Object)builder.build());
            return this;
        }

        public Builder keyList(@Nullable KeyList keyList) {
            this.key = new OneOf((Enum)KeyOneOfType.KEY_LIST, (Object)keyList);
            return this;
        }

        public Builder keyList(KeyList.Builder builder) {
            this.key = new OneOf((Enum)KeyOneOfType.KEY_LIST, (Object)builder.build());
            return this;
        }

        public Builder ecdsaSecp256k1(@NonNull Bytes ecdsaSecp256k1) {
            this.key = new OneOf((Enum)KeyOneOfType.ECDSA_SECP256K1, (Object)ecdsaSecp256k1);
            return this;
        }

        public Builder delegatableContractId(@Nullable ContractID delegatableContractId) {
            this.key = new OneOf((Enum)KeyOneOfType.DELEGATABLE_CONTRACT_ID, (Object)delegatableContractId);
            return this;
        }

        public Builder delegatableContractId(ContractID.Builder builder) {
            this.key = new OneOf((Enum)KeyOneOfType.DELEGATABLE_CONTRACT_ID, (Object)builder.build());
            return this;
        }
    }
}

