/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.codec.KeyListJsonCodec;
import com.hedera.hapi.node.base.codec.KeyListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record KeyList(@Nullable List<Key> keys) {
    public static final Codec<KeyList> PROTOBUF = new KeyListProtoCodec();
    public static final JsonCodec<KeyList> JSON = new KeyListJsonCodec();
    public static final KeyList DEFAULT = KeyList.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        List<Key> list$keys = this.keys;
        if (list$keys != null) {
            for (Key o : list$keys) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        KeyList thatObj = (KeyList)that;
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        return this.keys == null || this.keys.equals(thatObj.keys);
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public List<Key> keysOrElse(@NonNull List<Key> defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public List<Key> keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<List<Key>> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.keys);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<Key> keys = Collections.emptyList();

        public Builder() {
        }

        public Builder(List<Key> keys) {
            this.keys = keys;
        }

        public KeyList build() {
            return new KeyList(this.keys);
        }

        public Builder keys(@Nullable List<Key> keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(Key ... values) {
            this.keys = List.of(values);
            return this;
        }
    }
}

