/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.codec.NftTransferJsonCodec;
import com.hedera.hapi.node.base.codec.NftTransferProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record NftTransfer(@Nullable AccountID senderAccountID, @Nullable AccountID receiverAccountID, long serialNumber, boolean isApproval) {
    public static final Codec<NftTransfer> PROTOBUF = new NftTransferProtoCodec();
    public static final JsonCodec<NftTransfer> JSON = new NftTransferJsonCodec();
    public static final NftTransfer DEFAULT = NftTransfer.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.senderAccountID != null && !this.senderAccountID.equals(NftTransfer.DEFAULT.senderAccountID)) {
            result = 31 * result + this.senderAccountID.hashCode();
        }
        if (this.receiverAccountID != null && !this.receiverAccountID.equals(NftTransfer.DEFAULT.receiverAccountID)) {
            result = 31 * result + this.receiverAccountID.hashCode();
        }
        if (this.serialNumber != NftTransfer.DEFAULT.serialNumber) {
            result = 31 * result + Long.hashCode(this.serialNumber);
        }
        if (this.isApproval != NftTransfer.DEFAULT.isApproval) {
            result = 31 * result + Boolean.hashCode(this.isApproval);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NftTransfer thatObj = (NftTransfer)that;
        if (this.senderAccountID == null && thatObj.senderAccountID != null) {
            return false;
        }
        if (this.senderAccountID != null && !this.senderAccountID.equals(thatObj.senderAccountID)) {
            return false;
        }
        if (this.receiverAccountID == null && thatObj.receiverAccountID != null) {
            return false;
        }
        if (this.receiverAccountID != null && !this.receiverAccountID.equals(thatObj.receiverAccountID)) {
            return false;
        }
        if (this.serialNumber != thatObj.serialNumber) {
            return false;
        }
        return this.isApproval == thatObj.isApproval;
    }

    public boolean hasSenderAccountID() {
        return this.senderAccountID != null;
    }

    public AccountID senderAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderAccountID() ? this.senderAccountID : defaultValue;
    }

    @NonNull
    public AccountID senderAccountIDOrThrow() {
        return Objects.requireNonNull(this.senderAccountID, "Field senderAccountID is null");
    }

    public void ifSenderAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderAccountID()) {
            ifPresent.accept(this.senderAccountID);
        }
    }

    public boolean hasReceiverAccountID() {
        return this.receiverAccountID != null;
    }

    public AccountID receiverAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasReceiverAccountID() ? this.receiverAccountID : defaultValue;
    }

    @NonNull
    public AccountID receiverAccountIDOrThrow() {
        return Objects.requireNonNull(this.receiverAccountID, "Field receiverAccountID is null");
    }

    public void ifReceiverAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasReceiverAccountID()) {
            ifPresent.accept(this.receiverAccountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID senderAccountID = null;
        @Nullable
        private AccountID receiverAccountID = null;
        private long serialNumber = 0L;
        private boolean isApproval = false;

        public Builder() {
        }

        public Builder(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval) {
            this.senderAccountID = senderAccountID;
            this.receiverAccountID = receiverAccountID;
            this.serialNumber = serialNumber;
            this.isApproval = isApproval;
        }

        public NftTransfer build() {
            return new NftTransfer(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval);
        }

        public Builder senderAccountID(@Nullable AccountID senderAccountID) {
            this.senderAccountID = senderAccountID;
            return this;
        }

        public Builder senderAccountID(AccountID.Builder builder) {
            this.senderAccountID = builder.build();
            return this;
        }

        public Builder receiverAccountID(@Nullable AccountID receiverAccountID) {
            this.receiverAccountID = receiverAccountID;
            return this;
        }

        public Builder receiverAccountID(AccountID.Builder builder) {
            this.receiverAccountID = builder.build();
            return this;
        }

        public Builder serialNumber(long serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }
    }
}

