/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.base.codec.NodeAddressJsonCodec;
import com.hedera.hapi.node.base.codec.NodeAddressProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record NodeAddress(@NonNull Bytes ipAddress, int portno, @NonNull Bytes memo, String rsaPubKey, long nodeId, @Nullable AccountID nodeAccountId, @NonNull Bytes nodeCertHash, @Nullable List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
    public static final Codec<NodeAddress> PROTOBUF = new NodeAddressProtoCodec();
    public static final JsonCodec<NodeAddress> JSON = new NodeAddressJsonCodec();
    public static final NodeAddress DEFAULT = NodeAddress.newBuilder().build();

    @Override
    public int hashCode() {
        List<ServiceEndpoint> list$serviceEndpoint;
        int result = 1;
        if (this.ipAddress != null && !this.ipAddress.equals((Object)NodeAddress.DEFAULT.ipAddress)) {
            result = 31 * result + this.ipAddress.hashCode();
        }
        if (this.portno != NodeAddress.DEFAULT.portno) {
            result = 31 * result + Integer.hashCode(this.portno);
        }
        if (this.memo != null && !this.memo.equals((Object)NodeAddress.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.rsaPubKey != null && !this.rsaPubKey.equals(NodeAddress.DEFAULT.rsaPubKey)) {
            result = 31 * result + this.rsaPubKey.hashCode();
        }
        if (this.nodeId != NodeAddress.DEFAULT.nodeId) {
            result = 31 * result + Long.hashCode(this.nodeId);
        }
        if (this.nodeAccountId != null && !this.nodeAccountId.equals(NodeAddress.DEFAULT.nodeAccountId)) {
            result = 31 * result + this.nodeAccountId.hashCode();
        }
        if (this.nodeCertHash != null && !this.nodeCertHash.equals((Object)NodeAddress.DEFAULT.nodeCertHash)) {
            result = 31 * result + this.nodeCertHash.hashCode();
        }
        if ((list$serviceEndpoint = this.serviceEndpoint) != null) {
            for (ServiceEndpoint o : list$serviceEndpoint) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.description != null && !this.description.equals(NodeAddress.DEFAULT.description)) {
            result = 31 * result + this.description.hashCode();
        }
        if (this.stake != NodeAddress.DEFAULT.stake) {
            result = 31 * result + Long.hashCode(this.stake);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NodeAddress thatObj = (NodeAddress)that;
        if (this.ipAddress == null && thatObj.ipAddress != null) {
            return false;
        }
        if (this.ipAddress != null && !this.ipAddress.equals((Object)thatObj.ipAddress)) {
            return false;
        }
        if (this.portno != thatObj.portno) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals((Object)thatObj.memo)) {
            return false;
        }
        if (this.rsaPubKey == null && thatObj.rsaPubKey != null) {
            return false;
        }
        if (this.rsaPubKey != null && !this.rsaPubKey.equals(thatObj.rsaPubKey)) {
            return false;
        }
        if (this.nodeId != thatObj.nodeId) {
            return false;
        }
        if (this.nodeAccountId == null && thatObj.nodeAccountId != null) {
            return false;
        }
        if (this.nodeAccountId != null && !this.nodeAccountId.equals(thatObj.nodeAccountId)) {
            return false;
        }
        if (this.nodeCertHash == null && thatObj.nodeCertHash != null) {
            return false;
        }
        if (this.nodeCertHash != null && !this.nodeCertHash.equals((Object)thatObj.nodeCertHash)) {
            return false;
        }
        if (this.serviceEndpoint == null && thatObj.serviceEndpoint != null) {
            return false;
        }
        if (this.serviceEndpoint != null && !this.serviceEndpoint.equals(thatObj.serviceEndpoint)) {
            return false;
        }
        if (this.description == null && thatObj.description != null) {
            return false;
        }
        if (this.description != null && !this.description.equals(thatObj.description)) {
            return false;
        }
        return this.stake == thatObj.stake;
    }

    public boolean hasNodeAccountId() {
        return this.nodeAccountId != null;
    }

    public AccountID nodeAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasNodeAccountId() ? this.nodeAccountId : defaultValue;
    }

    @NonNull
    public AccountID nodeAccountIdOrThrow() {
        return Objects.requireNonNull(this.nodeAccountId, "Field nodeAccountId is null");
    }

    public void ifNodeAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasNodeAccountId()) {
            ifPresent.accept(this.nodeAccountId);
        }
    }

    public boolean hasServiceEndpoint() {
        return this.serviceEndpoint != null;
    }

    public List<ServiceEndpoint> serviceEndpointOrElse(@NonNull List<ServiceEndpoint> defaultValue) {
        return this.hasServiceEndpoint() ? this.serviceEndpoint : defaultValue;
    }

    @NonNull
    public List<ServiceEndpoint> serviceEndpointOrThrow() {
        return Objects.requireNonNull(this.serviceEndpoint, "Field serviceEndpoint is null");
    }

    public void ifServiceEndpoint(@NonNull Consumer<List<ServiceEndpoint>> ifPresent) {
        if (this.hasServiceEndpoint()) {
            ifPresent.accept(this.serviceEndpoint);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes ipAddress = Bytes.EMPTY;
        private int portno = 0;
        @NonNull
        private Bytes memo = Bytes.EMPTY;
        private String rsaPubKey = "";
        private long nodeId = 0L;
        @Nullable
        private AccountID nodeAccountId = null;
        @NonNull
        private Bytes nodeCertHash = Bytes.EMPTY;
        @Nullable
        private List<ServiceEndpoint> serviceEndpoint = Collections.emptyList();
        private String description = "";
        private long stake = 0L;

        public Builder() {
        }

        public Builder(Bytes ipAddress, int portno, Bytes memo, String rsaPubKey, long nodeId, AccountID nodeAccountId, Bytes nodeCertHash, List<ServiceEndpoint> serviceEndpoint, String description, long stake) {
            this.ipAddress = ipAddress;
            this.portno = portno;
            this.memo = memo;
            this.rsaPubKey = rsaPubKey;
            this.nodeId = nodeId;
            this.nodeAccountId = nodeAccountId;
            this.nodeCertHash = nodeCertHash;
            this.serviceEndpoint = serviceEndpoint;
            this.description = description;
            this.stake = stake;
        }

        public NodeAddress build() {
            return new NodeAddress(this.ipAddress, this.portno, this.memo, this.rsaPubKey, this.nodeId, this.nodeAccountId, this.nodeCertHash, this.serviceEndpoint, this.description, this.stake);
        }

        public Builder ipAddress(@NonNull Bytes ipAddress) {
            this.ipAddress = ipAddress != null ? ipAddress : Bytes.EMPTY;
            return this;
        }

        public Builder portno(int portno) {
            this.portno = portno;
            return this;
        }

        public Builder memo(@NonNull Bytes memo) {
            this.memo = memo != null ? memo : Bytes.EMPTY;
            return this;
        }

        public Builder rsaPubKey(String rsaPubKey) {
            this.rsaPubKey = rsaPubKey;
            return this;
        }

        public Builder nodeId(long nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder nodeAccountId(@Nullable AccountID nodeAccountId) {
            this.nodeAccountId = nodeAccountId;
            return this;
        }

        public Builder nodeAccountId(AccountID.Builder builder) {
            this.nodeAccountId = builder.build();
            return this;
        }

        public Builder nodeCertHash(@NonNull Bytes nodeCertHash) {
            this.nodeCertHash = nodeCertHash != null ? nodeCertHash : Bytes.EMPTY;
            return this;
        }

        public Builder serviceEndpoint(@Nullable List<ServiceEndpoint> serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder serviceEndpoint(ServiceEndpoint ... values) {
            this.serviceEndpoint = List.of(values);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder stake(long stake) {
            this.stake = stake;
            return this;
        }
    }
}

