/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.base.codec.QueryHeaderJsonCodec;
import com.hedera.hapi.node.base.codec.QueryHeaderProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record QueryHeader(@Nullable Transaction payment, ResponseType responseType) {
    public static final Codec<QueryHeader> PROTOBUF = new QueryHeaderProtoCodec();
    public static final JsonCodec<QueryHeader> JSON = new QueryHeaderJsonCodec();
    public static final QueryHeader DEFAULT = QueryHeader.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.payment != null && !this.payment.equals(QueryHeader.DEFAULT.payment)) {
            result = 31 * result + this.payment.hashCode();
        }
        if (this.responseType != null && !this.responseType.equals((Object)QueryHeader.DEFAULT.responseType)) {
            result = 31 * result + this.responseType.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        QueryHeader thatObj = (QueryHeader)that;
        if (this.payment == null && thatObj.payment != null) {
            return false;
        }
        if (this.payment != null && !this.payment.equals(thatObj.payment)) {
            return false;
        }
        if (this.responseType == null && thatObj.responseType != null) {
            return false;
        }
        return this.responseType == null || this.responseType.equals((Object)thatObj.responseType);
    }

    public boolean hasPayment() {
        return this.payment != null;
    }

    public Transaction paymentOrElse(@NonNull Transaction defaultValue) {
        return this.hasPayment() ? this.payment : defaultValue;
    }

    @NonNull
    public Transaction paymentOrThrow() {
        return Objects.requireNonNull(this.payment, "Field payment is null");
    }

    public void ifPayment(@NonNull Consumer<Transaction> ifPresent) {
        if (this.hasPayment()) {
            ifPresent.accept(this.payment);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.payment, this.responseType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Transaction payment = null;
        private ResponseType responseType = ResponseType.values()[0];

        public Builder() {
        }

        public Builder(Transaction payment, ResponseType responseType) {
            this.payment = payment;
            this.responseType = responseType;
        }

        public QueryHeader build() {
            return new QueryHeader(this.payment, this.responseType);
        }

        public Builder payment(@Nullable Transaction payment) {
            this.payment = payment;
            return this;
        }

        public Builder payment(Transaction.Builder builder) {
            this.payment = builder.build();
            return this;
        }

        public Builder responseType(ResponseType responseType) {
            this.responseType = responseType;
            return this;
        }
    }
}

