/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.SemanticVersionJsonCodec;
import com.hedera.hapi.node.base.codec.SemanticVersionProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;

public record SemanticVersion(int major, int minor, int patch, String pre, String build) {
    public static final Codec<SemanticVersion> PROTOBUF = new SemanticVersionProtoCodec();
    public static final JsonCodec<SemanticVersion> JSON = new SemanticVersionJsonCodec();
    public static final SemanticVersion DEFAULT = SemanticVersion.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.major != SemanticVersion.DEFAULT.major) {
            result = 31 * result + Integer.hashCode(this.major);
        }
        if (this.minor != SemanticVersion.DEFAULT.minor) {
            result = 31 * result + Integer.hashCode(this.minor);
        }
        if (this.patch != SemanticVersion.DEFAULT.patch) {
            result = 31 * result + Integer.hashCode(this.patch);
        }
        if (this.pre != null && !this.pre.equals(SemanticVersion.DEFAULT.pre)) {
            result = 31 * result + this.pre.hashCode();
        }
        if (this.build != null && !this.build.equals(SemanticVersion.DEFAULT.build)) {
            result = 31 * result + this.build.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SemanticVersion thatObj = (SemanticVersion)that;
        if (this.major != thatObj.major) {
            return false;
        }
        if (this.minor != thatObj.minor) {
            return false;
        }
        if (this.patch != thatObj.patch) {
            return false;
        }
        if (this.pre == null && thatObj.pre != null) {
            return false;
        }
        if (this.pre != null && !this.pre.equals(thatObj.pre)) {
            return false;
        }
        if (this.build == null && thatObj.build != null) {
            return false;
        }
        return this.build == null || this.build.equals(thatObj.build);
    }

    public Builder copyBuilder() {
        return new Builder(this.major, this.minor, this.patch, this.pre, this.build);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int major = 0;
        private int minor = 0;
        private int patch = 0;
        private String pre = "";
        private String build = "";

        public Builder() {
        }

        public Builder(int major, int minor, int patch, String pre, String build) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.pre = pre;
            this.build = build;
        }

        public SemanticVersion build() {
            return new SemanticVersion(this.major, this.minor, this.patch, this.pre, this.build);
        }

        public Builder major(int major) {
            this.major = major;
            return this;
        }

        public Builder minor(int minor) {
            this.minor = minor;
            return this;
        }

        public Builder patch(int patch) {
            this.patch = patch;
            return this;
        }

        public Builder pre(String pre) {
            this.pre = pre;
            return this;
        }

        public Builder build(String build) {
            this.build = build;
            return this;
        }
    }
}

