/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.codec.StakingInfoJsonCodec;
import com.hedera.hapi.node.base.codec.StakingInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record StakingInfo(boolean declineReward, @Nullable Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId) {
    public static final Codec<StakingInfo> PROTOBUF = new StakingInfoProtoCodec();
    public static final JsonCodec<StakingInfo> JSON = new StakingInfoJsonCodec();
    public static final StakingInfo DEFAULT = StakingInfo.newBuilder().build();

    public StakingInfo {
        if (stakedId == null) {
            throw new NullPointerException("Parameter 'stakedId' must be supplied and can not be null");
        }
    }

    @Override
    public int hashCode() {
        int result = 1;
        if (this.declineReward != StakingInfo.DEFAULT.declineReward) {
            result = 31 * result + Boolean.hashCode(this.declineReward);
        }
        if (this.stakePeriodStart != null && !this.stakePeriodStart.equals(StakingInfo.DEFAULT.stakePeriodStart)) {
            result = 31 * result + this.stakePeriodStart.hashCode();
        }
        if (this.pendingReward != StakingInfo.DEFAULT.pendingReward) {
            result = 31 * result + Long.hashCode(this.pendingReward);
        }
        if (this.stakedToMe != StakingInfo.DEFAULT.stakedToMe) {
            result = 31 * result + Long.hashCode(this.stakedToMe);
        }
        if (this.stakedId != null && !this.stakedId.equals(StakingInfo.DEFAULT.stakedId)) {
            result = 31 * result + this.stakedId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        StakingInfo thatObj = (StakingInfo)that;
        if (this.declineReward != thatObj.declineReward) {
            return false;
        }
        if (this.stakePeriodStart == null && thatObj.stakePeriodStart != null) {
            return false;
        }
        if (this.stakePeriodStart != null && !this.stakePeriodStart.equals(thatObj.stakePeriodStart)) {
            return false;
        }
        if (this.pendingReward != thatObj.pendingReward) {
            return false;
        }
        if (this.stakedToMe != thatObj.stakedToMe) {
            return false;
        }
        if (this.stakedId == null && thatObj.stakedId != null) {
            return false;
        }
        return this.stakedId == null || this.stakedId.equals(thatObj.stakedId);
    }

    public boolean hasStakePeriodStart() {
        return this.stakePeriodStart != null;
    }

    public Timestamp stakePeriodStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasStakePeriodStart() ? this.stakePeriodStart : defaultValue;
    }

    @NonNull
    public Timestamp stakePeriodStartOrThrow() {
        return Objects.requireNonNull(this.stakePeriodStart, "Field stakePeriodStart is null");
    }

    public void ifStakePeriodStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasStakePeriodStart()) {
            ifPresent.accept(this.stakePeriodStart);
        }
    }

    @Nullable
    public AccountID stakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID ? (AccountID)this.stakedId.value() : null;
    }

    public boolean hasStakedAccountId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_ACCOUNT_ID;
    }

    public AccountID stakedAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasStakedAccountId() ? this.stakedAccountId() : defaultValue;
    }

    @NonNull
    public AccountID stakedAccountIdOrThrow() {
        return Objects.requireNonNull(this.stakedAccountId(), "Field stakedAccountId is null");
    }

    @Nullable
    public Long stakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID ? (Long)this.stakedId.value() : null;
    }

    public boolean hasStakedNodeId() {
        return this.stakedId.kind() == StakedIdOneOfType.STAKED_NODE_ID;
    }

    public Long stakedNodeIdOrElse(@NonNull Long defaultValue) {
        return this.hasStakedNodeId() ? this.stakedNodeId() : defaultValue;
    }

    @NonNull
    public Long stakedNodeIdOrThrow() {
        return Objects.requireNonNull(this.stakedNodeId(), "Field stakedNodeId is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.declineReward, this.stakePeriodStart, this.pendingReward, this.stakedToMe, this.stakedId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum StakedIdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        STAKED_ACCOUNT_ID(5, "staked_account_id"),
        STAKED_NODE_ID(6, "staked_node_id");

        private final int protoOrdinal;
        private final String protoName;

        private StakedIdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static StakedIdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 5 -> STAKED_ACCOUNT_ID;
                case 6 -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static StakedIdOneOfType fromString(String name) {
            return switch (name) {
                case "staked_account_id", "STAKED_ACCOUNT_ID" -> STAKED_ACCOUNT_ID;
                case "staked_node_id", "STAKED_NODE_ID" -> STAKED_NODE_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private boolean declineReward = false;
        @Nullable
        private Timestamp stakePeriodStart = null;
        private long pendingReward = 0L;
        private long stakedToMe = 0L;
        private OneOf<StakedIdOneOfType> stakedId = StakingInfoProtoCodec.STAKED_ID_UNSET;

        public Builder() {
        }

        public Builder(boolean declineReward, Timestamp stakePeriodStart, long pendingReward, long stakedToMe, OneOf<StakedIdOneOfType> stakedId) {
            this.declineReward = declineReward;
            this.stakePeriodStart = stakePeriodStart;
            this.pendingReward = pendingReward;
            this.stakedToMe = stakedToMe;
            this.stakedId = stakedId;
        }

        public StakingInfo build() {
            return new StakingInfo(this.declineReward, this.stakePeriodStart, this.pendingReward, this.stakedToMe, this.stakedId);
        }

        public Builder declineReward(boolean declineReward) {
            this.declineReward = declineReward;
            return this;
        }

        public Builder stakePeriodStart(@Nullable Timestamp stakePeriodStart) {
            this.stakePeriodStart = stakePeriodStart;
            return this;
        }

        public Builder stakePeriodStart(Timestamp.Builder builder) {
            this.stakePeriodStart = builder.build();
            return this;
        }

        public Builder pendingReward(long pendingReward) {
            this.pendingReward = pendingReward;
            return this;
        }

        public Builder stakedToMe(long stakedToMe) {
            this.stakedToMe = stakedToMe;
            return this;
        }

        public Builder stakedAccountId(@Nullable AccountID stakedAccountId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)stakedAccountId);
            return this;
        }

        public Builder stakedAccountId(AccountID.Builder builder) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_ACCOUNT_ID, (Object)builder.build());
            return this;
        }

        public Builder stakedNodeId(long stakedNodeId) {
            this.stakedId = new OneOf((Enum)StakedIdOneOfType.STAKED_NODE_ID, (Object)stakedNodeId);
            return this;
        }
    }
}

