/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.codec.TimestampJsonCodec;
import com.hedera.hapi.node.base.codec.TimestampProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;

public record Timestamp(long seconds, int nanos) {
    public static final Codec<Timestamp> PROTOBUF = new TimestampProtoCodec();
    public static final JsonCodec<Timestamp> JSON = new TimestampJsonCodec();
    public static final Timestamp DEFAULT = Timestamp.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.seconds != Timestamp.DEFAULT.seconds) {
            result = 31 * result + Long.hashCode(this.seconds);
        }
        if (this.nanos != Timestamp.DEFAULT.nanos) {
            result = 31 * result + Integer.hashCode(this.nanos);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Timestamp thatObj = (Timestamp)that;
        if (this.seconds != thatObj.seconds) {
            return false;
        }
        return this.nanos == thatObj.nanos;
    }

    public Builder copyBuilder() {
        return new Builder(this.seconds, this.nanos);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long seconds = 0L;
        private int nanos = 0;

        public Builder() {
        }

        public Builder(long seconds, int nanos) {
            this.seconds = seconds;
            this.nanos = nanos;
        }

        public Timestamp build() {
            return new Timestamp(this.seconds, this.nanos);
        }

        public Builder seconds(long seconds) {
            this.seconds = seconds;
            return this;
        }

        public Builder nanos(int nanos) {
            this.nanos = nanos;
            return this;
        }
    }
}

