/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.codec.TokenRelationshipJsonCodec;
import com.hedera.hapi.node.base.codec.TokenRelationshipProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenRelationship(@Nullable TokenID tokenId, String symbol, long balance, TokenKycStatus kycStatus, TokenFreezeStatus freezeStatus, int decimals, boolean automaticAssociation) {
    public static final Codec<TokenRelationship> PROTOBUF = new TokenRelationshipProtoCodec();
    public static final JsonCodec<TokenRelationship> JSON = new TokenRelationshipJsonCodec();
    public static final TokenRelationship DEFAULT = TokenRelationship.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.tokenId != null && !this.tokenId.equals(TokenRelationship.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        if (this.symbol != null && !this.symbol.equals(TokenRelationship.DEFAULT.symbol)) {
            result = 31 * result + this.symbol.hashCode();
        }
        if (this.balance != TokenRelationship.DEFAULT.balance) {
            result = 31 * result + Long.hashCode(this.balance);
        }
        if (this.kycStatus != null && !this.kycStatus.equals((Object)TokenRelationship.DEFAULT.kycStatus)) {
            result = 31 * result + this.kycStatus.hashCode();
        }
        if (this.freezeStatus != null && !this.freezeStatus.equals((Object)TokenRelationship.DEFAULT.freezeStatus)) {
            result = 31 * result + this.freezeStatus.hashCode();
        }
        if (this.decimals != TokenRelationship.DEFAULT.decimals) {
            result = 31 * result + Integer.hashCode(this.decimals);
        }
        if (this.automaticAssociation != TokenRelationship.DEFAULT.automaticAssociation) {
            result = 31 * result + Boolean.hashCode(this.automaticAssociation);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TokenRelationship thatObj = (TokenRelationship)that;
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        if (this.tokenId != null && !this.tokenId.equals(thatObj.tokenId)) {
            return false;
        }
        if (this.symbol == null && thatObj.symbol != null) {
            return false;
        }
        if (this.symbol != null && !this.symbol.equals(thatObj.symbol)) {
            return false;
        }
        if (this.balance != thatObj.balance) {
            return false;
        }
        if (this.kycStatus == null && thatObj.kycStatus != null) {
            return false;
        }
        if (this.kycStatus != null && !this.kycStatus.equals((Object)thatObj.kycStatus)) {
            return false;
        }
        if (this.freezeStatus == null && thatObj.freezeStatus != null) {
            return false;
        }
        if (this.freezeStatus != null && !this.freezeStatus.equals((Object)thatObj.freezeStatus)) {
            return false;
        }
        if (this.decimals != thatObj.decimals) {
            return false;
        }
        return this.automaticAssociation == thatObj.automaticAssociation;
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.symbol, this.balance, this.kycStatus, this.freezeStatus, this.decimals, this.automaticAssociation);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TokenID tokenId = null;
        private String symbol = "";
        private long balance = 0L;
        private TokenKycStatus kycStatus = TokenKycStatus.values()[0];
        private TokenFreezeStatus freezeStatus = TokenFreezeStatus.values()[0];
        private int decimals = 0;
        private boolean automaticAssociation = false;

        public Builder() {
        }

        public Builder(TokenID tokenId, String symbol, long balance, TokenKycStatus kycStatus, TokenFreezeStatus freezeStatus, int decimals, boolean automaticAssociation) {
            this.tokenId = tokenId;
            this.symbol = symbol;
            this.balance = balance;
            this.kycStatus = kycStatus;
            this.freezeStatus = freezeStatus;
            this.decimals = decimals;
            this.automaticAssociation = automaticAssociation;
        }

        public TokenRelationship build() {
            return new TokenRelationship(this.tokenId, this.symbol, this.balance, this.kycStatus, this.freezeStatus, this.decimals, this.automaticAssociation);
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder kycStatus(TokenKycStatus kycStatus) {
            this.kycStatus = kycStatus;
            return this;
        }

        public Builder freezeStatus(TokenFreezeStatus freezeStatus) {
            this.freezeStatus = freezeStatus;
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder automaticAssociation(boolean automaticAssociation) {
            this.automaticAssociation = automaticAssociation;
            return this;
        }
    }
}

