/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.codec.TransactionJsonCodec;
import com.hedera.hapi.node.base.codec.TransactionProtoCodec;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record Transaction(@Nullable TransactionBody body, @Nullable SignatureList sigs, @Nullable SignatureMap sigMap, @NonNull Bytes bodyBytes, @NonNull Bytes signedTransactionBytes) {
    public static final Codec<Transaction> PROTOBUF = new TransactionProtoCodec();
    public static final JsonCodec<Transaction> JSON = new TransactionJsonCodec();
    public static final Transaction DEFAULT = Transaction.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.body != null && !this.body.equals(Transaction.DEFAULT.body)) {
            result = 31 * result + this.body.hashCode();
        }
        if (this.sigs != null && !this.sigs.equals(Transaction.DEFAULT.sigs)) {
            result = 31 * result + this.sigs.hashCode();
        }
        if (this.sigMap != null && !this.sigMap.equals(Transaction.DEFAULT.sigMap)) {
            result = 31 * result + this.sigMap.hashCode();
        }
        if (this.bodyBytes != null && !this.bodyBytes.equals((Object)Transaction.DEFAULT.bodyBytes)) {
            result = 31 * result + this.bodyBytes.hashCode();
        }
        if (this.signedTransactionBytes != null && !this.signedTransactionBytes.equals((Object)Transaction.DEFAULT.signedTransactionBytes)) {
            result = 31 * result + this.signedTransactionBytes.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Transaction thatObj = (Transaction)that;
        if (this.body == null && thatObj.body != null) {
            return false;
        }
        if (this.body != null && !this.body.equals(thatObj.body)) {
            return false;
        }
        if (this.sigs == null && thatObj.sigs != null) {
            return false;
        }
        if (this.sigs != null && !this.sigs.equals(thatObj.sigs)) {
            return false;
        }
        if (this.sigMap == null && thatObj.sigMap != null) {
            return false;
        }
        if (this.sigMap != null && !this.sigMap.equals(thatObj.sigMap)) {
            return false;
        }
        if (this.bodyBytes == null && thatObj.bodyBytes != null) {
            return false;
        }
        if (this.bodyBytes != null && !this.bodyBytes.equals((Object)thatObj.bodyBytes)) {
            return false;
        }
        if (this.signedTransactionBytes == null && thatObj.signedTransactionBytes != null) {
            return false;
        }
        return this.signedTransactionBytes == null || this.signedTransactionBytes.equals((Object)thatObj.signedTransactionBytes);
    }

    public boolean hasBody() {
        return this.body != null;
    }

    public TransactionBody bodyOrElse(@NonNull TransactionBody defaultValue) {
        return this.hasBody() ? this.body : defaultValue;
    }

    @NonNull
    public TransactionBody bodyOrThrow() {
        return Objects.requireNonNull(this.body, "Field body is null");
    }

    public void ifBody(@NonNull Consumer<TransactionBody> ifPresent) {
        if (this.hasBody()) {
            ifPresent.accept(this.body);
        }
    }

    public boolean hasSigs() {
        return this.sigs != null;
    }

    public SignatureList sigsOrElse(@NonNull SignatureList defaultValue) {
        return this.hasSigs() ? this.sigs : defaultValue;
    }

    @NonNull
    public SignatureList sigsOrThrow() {
        return Objects.requireNonNull(this.sigs, "Field sigs is null");
    }

    public void ifSigs(@NonNull Consumer<SignatureList> ifPresent) {
        if (this.hasSigs()) {
            ifPresent.accept(this.sigs);
        }
    }

    public boolean hasSigMap() {
        return this.sigMap != null;
    }

    public SignatureMap sigMapOrElse(@NonNull SignatureMap defaultValue) {
        return this.hasSigMap() ? this.sigMap : defaultValue;
    }

    @NonNull
    public SignatureMap sigMapOrThrow() {
        return Objects.requireNonNull(this.sigMap, "Field sigMap is null");
    }

    public void ifSigMap(@NonNull Consumer<SignatureMap> ifPresent) {
        if (this.hasSigMap()) {
            ifPresent.accept(this.sigMap);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.body, this.sigs, this.sigMap, this.bodyBytes, this.signedTransactionBytes);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TransactionBody body = null;
        @Nullable
        private SignatureList sigs = null;
        @Nullable
        private SignatureMap sigMap = null;
        @NonNull
        private Bytes bodyBytes = Bytes.EMPTY;
        @NonNull
        private Bytes signedTransactionBytes = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(TransactionBody body, SignatureList sigs, SignatureMap sigMap, Bytes bodyBytes, Bytes signedTransactionBytes) {
            this.body = body;
            this.sigs = sigs;
            this.sigMap = sigMap;
            this.bodyBytes = bodyBytes;
            this.signedTransactionBytes = signedTransactionBytes;
        }

        public Transaction build() {
            return new Transaction(this.body, this.sigs, this.sigMap, this.bodyBytes, this.signedTransactionBytes);
        }

        public Builder body(@Nullable TransactionBody body) {
            this.body = body;
            return this;
        }

        public Builder body(TransactionBody.Builder builder) {
            this.body = builder.build();
            return this;
        }

        public Builder sigs(@Nullable SignatureList sigs) {
            this.sigs = sigs;
            return this;
        }

        public Builder sigs(SignatureList.Builder builder) {
            this.sigs = builder.build();
            return this;
        }

        public Builder sigMap(@Nullable SignatureMap sigMap) {
            this.sigMap = sigMap;
            return this;
        }

        public Builder sigMap(SignatureMap.Builder builder) {
            this.sigMap = builder.build();
            return this;
        }

        public Builder bodyBytes(@NonNull Bytes bodyBytes) {
            this.bodyBytes = bodyBytes != null ? bodyBytes : Bytes.EMPTY;
            return this;
        }

        public Builder signedTransactionBytes(@NonNull Bytes signedTransactionBytes) {
            this.signedTransactionBytes = signedTransactionBytes != null ? signedTransactionBytes : Bytes.EMPTY;
            return this;
        }
    }
}

