/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.codec.TransactionIDJsonCodec;
import com.hedera.hapi.node.base.codec.TransactionIDProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TransactionID(@Nullable Timestamp transactionValidStart, @Nullable AccountID accountID, boolean scheduled, int nonce) {
    public static final Codec<TransactionID> PROTOBUF = new TransactionIDProtoCodec();
    public static final JsonCodec<TransactionID> JSON = new TransactionIDJsonCodec();
    public static final TransactionID DEFAULT = TransactionID.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.transactionValidStart != null && !this.transactionValidStart.equals(TransactionID.DEFAULT.transactionValidStart)) {
            result = 31 * result + this.transactionValidStart.hashCode();
        }
        if (this.accountID != null && !this.accountID.equals(TransactionID.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.scheduled != TransactionID.DEFAULT.scheduled) {
            result = 31 * result + Boolean.hashCode(this.scheduled);
        }
        if (this.nonce != TransactionID.DEFAULT.nonce) {
            result = 31 * result + Integer.hashCode(this.nonce);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransactionID thatObj = (TransactionID)that;
        if (this.transactionValidStart == null && thatObj.transactionValidStart != null) {
            return false;
        }
        if (this.transactionValidStart != null && !this.transactionValidStart.equals(thatObj.transactionValidStart)) {
            return false;
        }
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.scheduled != thatObj.scheduled) {
            return false;
        }
        return this.nonce == thatObj.nonce;
    }

    public boolean hasTransactionValidStart() {
        return this.transactionValidStart != null;
    }

    public Timestamp transactionValidStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasTransactionValidStart() ? this.transactionValidStart : defaultValue;
    }

    @NonNull
    public Timestamp transactionValidStartOrThrow() {
        return Objects.requireNonNull(this.transactionValidStart, "Field transactionValidStart is null");
    }

    public void ifTransactionValidStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasTransactionValidStart()) {
            ifPresent.accept(this.transactionValidStart);
        }
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transactionValidStart, this.accountID, this.scheduled, this.nonce);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Timestamp transactionValidStart = null;
        @Nullable
        private AccountID accountID = null;
        private boolean scheduled = false;
        private int nonce = 0;

        public Builder() {
        }

        public Builder(Timestamp transactionValidStart, AccountID accountID, boolean scheduled, int nonce) {
            this.transactionValidStart = transactionValidStart;
            this.accountID = accountID;
            this.scheduled = scheduled;
            this.nonce = nonce;
        }

        public TransactionID build() {
            return new TransactionID(this.transactionValidStart, this.accountID, this.scheduled, this.nonce);
        }

        public Builder transactionValidStart(@Nullable Timestamp transactionValidStart) {
            this.transactionValidStart = transactionValidStart;
            return this;
        }

        public Builder transactionValidStart(Timestamp.Builder builder) {
            this.transactionValidStart = builder.build();
            return this;
        }

        public Builder accountID(@Nullable AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder scheduled(boolean scheduled) {
            this.scheduled = scheduled;
            return this;
        }

        public Builder nonce(int nonce) {
            this.nonce = nonce;
            return this;
        }
    }
}

