/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.codec.TransferListJsonCodec;
import com.hedera.hapi.node.base.codec.TransferListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TransferList(@Nullable List<AccountAmount> accountAmounts) {
    public static final Codec<TransferList> PROTOBUF = new TransferListProtoCodec();
    public static final JsonCodec<TransferList> JSON = new TransferListJsonCodec();
    public static final TransferList DEFAULT = TransferList.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        List<AccountAmount> list$accountAmounts = this.accountAmounts;
        if (list$accountAmounts != null) {
            for (AccountAmount o : list$accountAmounts) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        TransferList thatObj = (TransferList)that;
        if (this.accountAmounts == null && thatObj.accountAmounts != null) {
            return false;
        }
        return this.accountAmounts == null || this.accountAmounts.equals(thatObj.accountAmounts);
    }

    public boolean hasAccountAmounts() {
        return this.accountAmounts != null;
    }

    public List<AccountAmount> accountAmountsOrElse(@NonNull List<AccountAmount> defaultValue) {
        return this.hasAccountAmounts() ? this.accountAmounts : defaultValue;
    }

    @NonNull
    public List<AccountAmount> accountAmountsOrThrow() {
        return Objects.requireNonNull(this.accountAmounts, "Field accountAmounts is null");
    }

    public void ifAccountAmounts(@NonNull Consumer<List<AccountAmount>> ifPresent) {
        if (this.hasAccountAmounts()) {
            ifPresent.accept(this.accountAmounts);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountAmounts);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<AccountAmount> accountAmounts = Collections.emptyList();

        public Builder() {
        }

        public Builder(List<AccountAmount> accountAmounts) {
            this.accountAmounts = accountAmounts;
        }

        public TransferList build() {
            return new TransferList(this.accountAmounts);
        }

        public Builder accountAmounts(@Nullable List<AccountAmount> accountAmounts) {
            this.accountAmounts = accountAmounts;
            return this;
        }

        public Builder accountAmounts(AccountAmount ... values) {
            this.accountAmounts = List.of(values);
            return this;
        }
    }
}

