/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.schema.ContractIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ContractIDProtoCodec
implements Codec<ContractID> {
    public static final OneOf<ContractID.ContractOneOfType> CONTRACT_UNSET = new OneOf((Enum)ContractID.ContractOneOfType.UNSET, null);

    @NonNull
    public ContractID parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractID parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractIDSchema.SHARD_NUM, (long)data.shardNum());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractIDSchema.REALM_NUM, (long)data.realmNum());
        if (data.contract().kind() == ContractID.ContractOneOfType.CONTRACT_NUM) {
            ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ContractIDSchema.CONTRACT_NUM, (long)((Long)data.contract().as()));
        }
        if (data.contract().kind() == ContractID.ContractOneOfType.EVM_ADDRESS) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)ContractIDSchema.EVM_ADDRESS, (RandomAccessData)((RandomAccessData)data.contract().as()));
        }
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractID data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.SHARD_NUM, (long)data.shardNum());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.REALM_NUM, (long)data.realmNum());
        if (data.contract().kind() == ContractID.ContractOneOfType.CONTRACT_NUM) {
            size += ProtoWriterTools.sizeOfLong((FieldDefinition)ContractIDSchema.CONTRACT_NUM, (long)((Long)data.contract().as()));
        }
        if (data.contract().kind() == ContractID.ContractOneOfType.EVM_ADDRESS) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)ContractIDSchema.EVM_ADDRESS, (RandomAccessData)((RandomAccessData)data.contract().as()));
        }
        return size;
    }

    public boolean fastEquals(@NonNull ContractID item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private ContractID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            long temp_shardNum = 0L;
            long temp_realmNum = 0L;
            OneOf temp_contract = CONTRACT_UNSET;
            block10: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = ContractIDSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_shardNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 16: {
                        long value;
                        temp_realmNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block10;
                    }
                    case 24: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_contract = new OneOf((Enum)ContractID.ContractOneOfType.CONTRACT_NUM, (Object)value);
                        continue block10;
                    }
                    case 34: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_contract = new OneOf((Enum)ContractID.ContractOneOfType.EVM_ADDRESS, (Object)value);
                        continue block10;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ContractID(temp_shardNum, temp_realmNum, temp_contract);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

