/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.ThresholdKey;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class KeyJsonCodec
implements JsonCodec<Key> {
    public static final OneOf<Key.KeyOneOfType> KEY_UNSET = new OneOf((Enum)Key.KeyOneOfType.UNSET, null);

    @NonNull
    public Key parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            OneOf temp_key = KEY_UNSET;
            block22: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractID": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.CONTRACT_ID, ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block22;
                    }
                    case "ed25519": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.ED25519, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block22;
                    }
                    case "RSA3072": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.RSA_3072, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block22;
                    }
                    case "ECDSA384": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.ECDSA_384, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block22;
                    }
                    case "thresholdKey": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.THRESHOLD_KEY, ThresholdKey.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block22;
                    }
                    case "keyList": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.KEY_LIST, KeyList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block22;
                    }
                    case "ECDSASecp256k1": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.ECDSA_SECP256K1, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                        continue block22;
                    }
                    case "delegatableContractId": {
                        temp_key = new OneOf((Enum)Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID, ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false));
                        continue block22;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Key(temp_key);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Key data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.key().kind() == Key.KeyOneOfType.CONTRACT_ID) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.key().kind() == Key.KeyOneOfType.ED25519) {
            fieldLines.add(JsonTools.field((String)"ed25519", (Bytes)data.ed25519()));
        }
        if (data.key().kind() == Key.KeyOneOfType.RSA_3072) {
            fieldLines.add(JsonTools.field((String)"RSA3072", (Bytes)data.rsa3072()));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_384) {
            fieldLines.add(JsonTools.field((String)"ECDSA384", (Bytes)data.ecdsa384()));
        }
        if (data.key().kind() == Key.KeyOneOfType.THRESHOLD_KEY) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"thresholdKey", ThresholdKey.JSON, (Object)data.thresholdKey()));
        }
        if (data.key().kind() == Key.KeyOneOfType.KEY_LIST) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"keyList", KeyList.JSON, (Object)data.keyList()));
        }
        if (data.key().kind() == Key.KeyOneOfType.ECDSA_SECP256K1) {
            fieldLines.add(JsonTools.field((String)"ECDSASecp256k1", (Bytes)data.ecdsaSecp256k1()));
        }
        if (data.key().kind() == Key.KeyOneOfType.DELEGATABLE_CONTRACT_ID) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"delegatableContractId", ContractID.JSON, (Object)data.delegatableContractId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

