/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.schema.NftTransferSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class NftTransferProtoCodec
implements Codec<NftTransfer> {
    @NonNull
    public NftTransfer parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NftTransfer parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NftTransfer data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)data.senderAccountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)data.receiverAccountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)data.serialNumber());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)data.isApproval());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NftTransfer data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)data.senderAccountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)data.receiverAccountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)data.serialNumber());
        return size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)data.isApproval());
    }

    public boolean fastEquals(@NonNull NftTransfer item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NonNull
    private NftTransfer parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            temp_senderAccountID = null;
            temp_receiverAccountID = null;
            temp_serialNumber = 0L;
            temp_is_approval = false;
            block16: while (input.hasRemaining()) {
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                field = tag >>> 3;
                f = NftTransferSchema.getField(field);
                switch (tag) {
                    case 10: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl20
                        value = AccountID.DEFAULT;
                        ** GOTO lbl33
lbl20:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v0 = value = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl33:
                        // 2 sources

                        temp_senderAccountID = value;
                        continue block16;
                    }
                    case 18: {
                        messageLength = input.readVarInt(false);
                        if (messageLength != 0) ** GOTO lbl40
                        value = AccountID.DEFAULT;
                        ** GOTO lbl53
lbl40:
                        // 1 sources

                        limitBefore = input.limit();
                        startPos = input.position();
                        try {
                            if (startPos + (long)messageLength > limitBefore) {
                                throw new BufferUnderflowException();
                            }
                            input.limit(startPos + (long)messageLength);
                            v1 = value = strictMode != false ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                            if (startPos + (long)messageLength != input.position()) {
                                throw new BufferOverflowException();
                            }
                        }
                        finally {
                            input.limit(limitBefore);
                        }
lbl53:
                        // 2 sources

                        temp_receiverAccountID = value;
                        continue block16;
                    }
                    case 24: {
                        temp_serialNumber = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block16;
                    }
                    case 32: {
                        temp_is_approval = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block16;
                    }
                }
                wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new NftTransfer(temp_senderAccountID, temp_receiverAccountID, temp_serialNumber, temp_is_approval);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

