/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.base.schema.ShardIDSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ShardIDProtoCodec
implements Codec<ShardID> {
    @NonNull
    public ShardID parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ShardID parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ShardID data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ShardIDSchema.SHARD_NUM, (long)data.shardNum());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ShardID data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)ShardIDSchema.SHARD_NUM, (long)data.shardNum());
    }

    public boolean fastEquals(@NonNull ShardID item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private ShardID parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            long temp_shardNum = 0L;
            block7: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = ShardIDSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_shardNum = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new ShardID(temp_shardNum);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

