/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.schema.TimestampSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TimestampProtoCodec
implements Codec<Timestamp> {
    @NonNull
    public Timestamp parse(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Timestamp parseStrict(@NonNull ReadableSequentialData input) throws ParseException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Timestamp data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TimestampSchema.SECONDS, (long)data.seconds());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TimestampSchema.NANOS, (int)data.nanos());
    }

    public int measure(@NonNull ReadableSequentialData input) throws ParseException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Timestamp data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TimestampSchema.SECONDS, (long)data.seconds());
        return size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TimestampSchema.NANOS, (int)data.nanos());
    }

    public boolean fastEquals(@NonNull Timestamp item, @NonNull ReadableSequentialData input) throws ParseException {
        return item.equals(this.parse(input));
    }

    @NonNull
    private Timestamp parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws ParseException {
        try {
            long temp_seconds = 0L;
            int temp_nanos = 0;
            block8: while (input.hasRemaining()) {
                int tag;
                try {
                    tag = input.readVarInt(false);
                }
                catch (EOFException e) {
                    break;
                }
                int field = tag >>> 3;
                FieldDefinition f = TimestampSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_seconds = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 16: {
                        int value;
                        temp_nanos = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f == null) {
                    if (strictMode) {
                        throw new UnknownFieldException(field);
                    }
                    ProtoParserTools.skipField((ReadableSequentialData)input, (ProtoConstants)ProtoConstants.get((int)wireType));
                    continue;
                }
                throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
            }
            return new Timestamp(temp_seconds, temp_nanos);
        }
        catch (Exception anyException) {
            throw new ParseException((Throwable)anyException);
        }
    }
}

