/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.SignatureList;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class TransactionJsonCodec
implements JsonCodec<Transaction> {
    @NonNull
    public Transaction parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            TransactionBody temp_body = null;
            SignatureList temp_sigs = null;
            SignatureMap temp_sigMap = null;
            Bytes temp_bodyBytes = Bytes.EMPTY;
            Bytes temp_signedTransactionBytes = Bytes.EMPTY;
            block16: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "body": {
                        temp_body = (TransactionBody)TransactionBody.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block16;
                    }
                    case "sigs": {
                        temp_sigs = (SignatureList)SignatureList.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block16;
                    }
                    case "sigMap": {
                        temp_sigMap = (SignatureMap)SignatureMap.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block16;
                    }
                    case "bodyBytes": {
                        temp_bodyBytes = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block16;
                    }
                    case "signedTransactionBytes": {
                        temp_signedTransactionBytes = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block16;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new Transaction(temp_body, temp_sigs, temp_sigMap, temp_bodyBytes, temp_signedTransactionBytes);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull Transaction data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.body() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"body", TransactionBody.JSON, (Object)data.body()));
        }
        if (data.sigs() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"sigs", SignatureList.JSON, (Object)data.sigs()));
        }
        if (data.sigMap() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"sigMap", SignatureMap.JSON, (Object)data.sigMap()));
        }
        if (data.bodyBytes() != Bytes.EMPTY && data.bodyBytes() != null && data.bodyBytes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"bodyBytes", (Bytes)data.bodyBytes()));
        }
        if (data.signedTransactionBytes() != Bytes.EMPTY && data.signedTransactionBytes() != null && data.signedTransactionBytes().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"signedTransactionBytes", (Bytes)data.signedTransactionBytes()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

