/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.consensus.codec.ConsensusCreateTopicTransactionBodyJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusCreateTopicTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusCreateTopicTransactionBody(String memo, @Nullable Key adminKey, @Nullable Key submitKey, @Nullable Duration autoRenewPeriod, @Nullable AccountID autoRenewAccount) {
    public static final Codec<ConsensusCreateTopicTransactionBody> PROTOBUF = new ConsensusCreateTopicTransactionBodyProtoCodec();
    public static final JsonCodec<ConsensusCreateTopicTransactionBody> JSON = new ConsensusCreateTopicTransactionBodyJsonCodec();
    public static final ConsensusCreateTopicTransactionBody DEFAULT = ConsensusCreateTopicTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.memo != null && !this.memo.equals(ConsensusCreateTopicTransactionBody.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(ConsensusCreateTopicTransactionBody.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.submitKey != null && !this.submitKey.equals(ConsensusCreateTopicTransactionBody.DEFAULT.submitKey)) {
            result = 31 * result + this.submitKey.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(ConsensusCreateTopicTransactionBody.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(ConsensusCreateTopicTransactionBody.DEFAULT.autoRenewAccount)) {
            result = 31 * result + this.autoRenewAccount.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ConsensusCreateTopicTransactionBody thatObj = (ConsensusCreateTopicTransactionBody)that;
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.submitKey == null && thatObj.submitKey != null) {
            return false;
        }
        if (this.submitKey != null && !this.submitKey.equals(thatObj.submitKey)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.autoRenewAccount == null && thatObj.autoRenewAccount != null) {
            return false;
        }
        return this.autoRenewAccount == null || this.autoRenewAccount.equals(thatObj.autoRenewAccount);
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.memo, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String memo = "";
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key submitKey = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        @Nullable
        private AccountID autoRenewAccount = null;

        public Builder() {
        }

        public Builder(String memo, Key adminKey, Key submitKey, Duration autoRenewPeriod, AccountID autoRenewAccount) {
            this.memo = memo;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccount = autoRenewAccount;
        }

        public ConsensusCreateTopicTransactionBody build() {
            return new ConsensusCreateTopicTransactionBody(this.memo, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(@Nullable Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder autoRenewAccount(@Nullable AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }
    }
}

