/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.consensus.codec.ConsensusMessageChunkInfoJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusMessageChunkInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusMessageChunkInfo(@Nullable TransactionID initialTransactionID, int total, int number) {
    public static final Codec<ConsensusMessageChunkInfo> PROTOBUF = new ConsensusMessageChunkInfoProtoCodec();
    public static final JsonCodec<ConsensusMessageChunkInfo> JSON = new ConsensusMessageChunkInfoJsonCodec();
    public static final ConsensusMessageChunkInfo DEFAULT = ConsensusMessageChunkInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.initialTransactionID != null && !this.initialTransactionID.equals(ConsensusMessageChunkInfo.DEFAULT.initialTransactionID)) {
            result = 31 * result + this.initialTransactionID.hashCode();
        }
        if (this.total != ConsensusMessageChunkInfo.DEFAULT.total) {
            result = 31 * result + Integer.hashCode(this.total);
        }
        if (this.number != ConsensusMessageChunkInfo.DEFAULT.number) {
            result = 31 * result + Integer.hashCode(this.number);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ConsensusMessageChunkInfo thatObj = (ConsensusMessageChunkInfo)that;
        if (this.initialTransactionID == null && thatObj.initialTransactionID != null) {
            return false;
        }
        if (this.initialTransactionID != null && !this.initialTransactionID.equals(thatObj.initialTransactionID)) {
            return false;
        }
        if (this.total != thatObj.total) {
            return false;
        }
        return this.number == thatObj.number;
    }

    public boolean hasInitialTransactionID() {
        return this.initialTransactionID != null;
    }

    public TransactionID initialTransactionIDOrElse(@NonNull TransactionID defaultValue) {
        return this.hasInitialTransactionID() ? this.initialTransactionID : defaultValue;
    }

    @NonNull
    public TransactionID initialTransactionIDOrThrow() {
        return Objects.requireNonNull(this.initialTransactionID, "Field initialTransactionID is null");
    }

    public void ifInitialTransactionID(@NonNull Consumer<TransactionID> ifPresent) {
        if (this.hasInitialTransactionID()) {
            ifPresent.accept(this.initialTransactionID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.initialTransactionID, this.total, this.number);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TransactionID initialTransactionID = null;
        private int total = 0;
        private int number = 0;

        public Builder() {
        }

        public Builder(TransactionID initialTransactionID, int total, int number) {
            this.initialTransactionID = initialTransactionID;
            this.total = total;
            this.number = number;
        }

        public ConsensusMessageChunkInfo build() {
            return new ConsensusMessageChunkInfo(this.initialTransactionID, this.total, this.number);
        }

        public Builder initialTransactionID(@Nullable TransactionID initialTransactionID) {
            this.initialTransactionID = initialTransactionID;
            return this;
        }

        public Builder initialTransactionID(TransactionID.Builder builder) {
            this.initialTransactionID = builder.build();
            return this;
        }

        public Builder total(int total) {
            this.total = total;
            return this;
        }

        public Builder number(int number) {
            this.number = number;
            return this;
        }
    }
}

