/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.consensus.codec.ConsensusTopicInfoJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusTopicInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusTopicInfo(String memo, @NonNull Bytes runningHash, long sequenceNumber, @Nullable Timestamp expirationTime, @Nullable Key adminKey, @Nullable Key submitKey, @Nullable Duration autoRenewPeriod, @Nullable AccountID autoRenewAccount, @NonNull Bytes ledgerId) {
    public static final Codec<ConsensusTopicInfo> PROTOBUF = new ConsensusTopicInfoProtoCodec();
    public static final JsonCodec<ConsensusTopicInfo> JSON = new ConsensusTopicInfoJsonCodec();
    public static final ConsensusTopicInfo DEFAULT = ConsensusTopicInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.memo != null && !this.memo.equals(ConsensusTopicInfo.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.runningHash != null && !this.runningHash.equals((Object)ConsensusTopicInfo.DEFAULT.runningHash)) {
            result = 31 * result + this.runningHash.hashCode();
        }
        if (this.sequenceNumber != ConsensusTopicInfo.DEFAULT.sequenceNumber) {
            result = 31 * result + Long.hashCode(this.sequenceNumber);
        }
        if (this.expirationTime != null && !this.expirationTime.equals(ConsensusTopicInfo.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(ConsensusTopicInfo.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.submitKey != null && !this.submitKey.equals(ConsensusTopicInfo.DEFAULT.submitKey)) {
            result = 31 * result + this.submitKey.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(ConsensusTopicInfo.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(ConsensusTopicInfo.DEFAULT.autoRenewAccount)) {
            result = 31 * result + this.autoRenewAccount.hashCode();
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)ConsensusTopicInfo.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ConsensusTopicInfo thatObj = (ConsensusTopicInfo)that;
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.runningHash == null && thatObj.runningHash != null) {
            return false;
        }
        if (this.runningHash != null && !this.runningHash.equals((Object)thatObj.runningHash)) {
            return false;
        }
        if (this.sequenceNumber != thatObj.sequenceNumber) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.submitKey == null && thatObj.submitKey != null) {
            return false;
        }
        if (this.submitKey != null && !this.submitKey.equals(thatObj.submitKey)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.autoRenewAccount == null && thatObj.autoRenewAccount != null) {
            return false;
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(thatObj.autoRenewAccount)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        return this.ledgerId == null || this.ledgerId.equals((Object)thatObj.ledgerId);
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.memo, this.runningHash, this.sequenceNumber, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount, this.ledgerId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String memo = "";
        @NonNull
        private Bytes runningHash = Bytes.EMPTY;
        private long sequenceNumber = 0L;
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key submitKey = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        @Nullable
        private AccountID autoRenewAccount = null;
        @NonNull
        private Bytes ledgerId = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(String memo, Bytes runningHash, long sequenceNumber, Timestamp expirationTime, Key adminKey, Key submitKey, Duration autoRenewPeriod, AccountID autoRenewAccount, Bytes ledgerId) {
            this.memo = memo;
            this.runningHash = runningHash;
            this.sequenceNumber = sequenceNumber;
            this.expirationTime = expirationTime;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccount = autoRenewAccount;
            this.ledgerId = ledgerId;
        }

        public ConsensusTopicInfo build() {
            return new ConsensusTopicInfo(this.memo, this.runningHash, this.sequenceNumber, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount, this.ledgerId);
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder runningHash(@NonNull Bytes runningHash) {
            this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
            return this;
        }

        public Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(@Nullable Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder autoRenewAccount(@Nullable AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }

        public Builder ledgerId(@NonNull Bytes ledgerId) {
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            return this;
        }
    }
}

