/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.consensus.codec.ConsensusUpdateTopicTransactionBodyJsonCodec;
import com.hedera.hapi.node.consensus.codec.ConsensusUpdateTopicTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ConsensusUpdateTopicTransactionBody(@Nullable TopicID topicID, @Nullable String memo, @Nullable Timestamp expirationTime, @Nullable Key adminKey, @Nullable Key submitKey, @Nullable Duration autoRenewPeriod, @Nullable AccountID autoRenewAccount) {
    public static final Codec<ConsensusUpdateTopicTransactionBody> PROTOBUF = new ConsensusUpdateTopicTransactionBodyProtoCodec();
    public static final JsonCodec<ConsensusUpdateTopicTransactionBody> JSON = new ConsensusUpdateTopicTransactionBodyJsonCodec();
    public static final ConsensusUpdateTopicTransactionBody DEFAULT = ConsensusUpdateTopicTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.topicID != null && !this.topicID.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.topicID)) {
            result = 31 * result + this.topicID.hashCode();
        }
        if (this.memo != null && !this.memo.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.expirationTime != null && !this.expirationTime.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.submitKey != null && !this.submitKey.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.submitKey)) {
            result = 31 * result + this.submitKey.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if (this.autoRenewAccount != null && !this.autoRenewAccount.equals(ConsensusUpdateTopicTransactionBody.DEFAULT.autoRenewAccount)) {
            result = 31 * result + this.autoRenewAccount.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ConsensusUpdateTopicTransactionBody thatObj = (ConsensusUpdateTopicTransactionBody)that;
        if (this.topicID == null && thatObj.topicID != null) {
            return false;
        }
        if (this.topicID != null && !this.topicID.equals(thatObj.topicID)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.submitKey == null && thatObj.submitKey != null) {
            return false;
        }
        if (this.submitKey != null && !this.submitKey.equals(thatObj.submitKey)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.autoRenewAccount == null && thatObj.autoRenewAccount != null) {
            return false;
        }
        return this.autoRenewAccount == null || this.autoRenewAccount.equals(thatObj.autoRenewAccount);
    }

    public boolean hasTopicID() {
        return this.topicID != null;
    }

    public TopicID topicIDOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicID() ? this.topicID : defaultValue;
    }

    @NonNull
    public TopicID topicIDOrThrow() {
        return Objects.requireNonNull(this.topicID, "Field topicID is null");
    }

    public void ifTopicID(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicID()) {
            ifPresent.accept(this.topicID);
        }
    }

    public boolean hasMemo() {
        return this.memo != null;
    }

    public String memoOrElse(@NonNull String defaultValue) {
        return this.hasMemo() ? this.memo : defaultValue;
    }

    @NonNull
    public String memoOrThrow() {
        return Objects.requireNonNull(this.memo, "Field memo is null");
    }

    public void ifMemo(@NonNull Consumer<String> ifPresent) {
        if (this.hasMemo()) {
            ifPresent.accept(this.memo);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasAutoRenewAccount() {
        return this.autoRenewAccount != null;
    }

    public AccountID autoRenewAccountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccount() ? this.autoRenewAccount : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccount, "Field autoRenewAccount is null");
    }

    public void ifAutoRenewAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccount()) {
            ifPresent.accept(this.autoRenewAccount);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.topicID, this.memo, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TopicID topicID = null;
        @Nullable
        private String memo = null;
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key submitKey = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        @Nullable
        private AccountID autoRenewAccount = null;

        public Builder() {
        }

        public Builder(TopicID topicID, String memo, Timestamp expirationTime, Key adminKey, Key submitKey, Duration autoRenewPeriod, AccountID autoRenewAccount) {
            this.topicID = topicID;
            this.memo = memo;
            this.expirationTime = expirationTime;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccount = autoRenewAccount;
        }

        public ConsensusUpdateTopicTransactionBody build() {
            return new ConsensusUpdateTopicTransactionBody(this.topicID, this.memo, this.expirationTime, this.adminKey, this.submitKey, this.autoRenewPeriod, this.autoRenewAccount);
        }

        public Builder topicID(@Nullable TopicID topicID) {
            this.topicID = topicID;
            return this;
        }

        public Builder topicID(TopicID.Builder builder) {
            this.topicID = builder.build();
            return this;
        }

        public Builder memo(@Nullable String memo) {
            this.memo = memo;
            return this;
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(@Nullable Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder autoRenewAccount(@Nullable AccountID autoRenewAccount) {
            this.autoRenewAccount = autoRenewAccount;
            return this;
        }

        public Builder autoRenewAccount(AccountID.Builder builder) {
            this.autoRenewAccount = builder.build();
            return this;
        }
    }
}

