/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.consensus.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.consensus.ConsensusTopicInfo;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class ConsensusTopicInfoJsonCodec
implements JsonCodec<ConsensusTopicInfo> {
    @NonNull
    public ConsensusTopicInfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            String temp_memo = "";
            Bytes temp_runningHash = Bytes.EMPTY;
            long temp_sequenceNumber = 0L;
            Timestamp temp_expirationTime = null;
            Key temp_adminKey = null;
            Key temp_submitKey = null;
            Duration temp_autoRenewPeriod = null;
            AccountID temp_autoRenewAccount = null;
            Bytes temp_ledger_id = Bytes.EMPTY;
            block24: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "memo": {
                        temp_memo = JsonTools.unescape((String)kvPair.value().STRING().getText());
                        continue block24;
                    }
                    case "runningHash": {
                        temp_runningHash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block24;
                    }
                    case "sequenceNumber": {
                        temp_sequenceNumber = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block24;
                    }
                    case "expirationTime": {
                        temp_expirationTime = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block24;
                    }
                    case "adminKey": {
                        temp_adminKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block24;
                    }
                    case "submitKey": {
                        temp_submitKey = (Key)Key.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block24;
                    }
                    case "autoRenewPeriod": {
                        temp_autoRenewPeriod = (Duration)Duration.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block24;
                    }
                    case "autoRenewAccount": {
                        temp_autoRenewAccount = (AccountID)AccountID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block24;
                    }
                    case "ledgerId": {
                        temp_ledger_id = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block24;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ConsensusTopicInfo(temp_memo, temp_runningHash, temp_sequenceNumber, temp_expirationTime, temp_adminKey, temp_submitKey, temp_autoRenewPeriod, temp_autoRenewAccount, temp_ledger_id);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ConsensusTopicInfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.memo() != "") {
            fieldLines.add(JsonTools.field((String)"memo", (String)data.memo()));
        }
        if (data.runningHash() != Bytes.EMPTY && data.runningHash() != null && data.runningHash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"runningHash", (Bytes)data.runningHash()));
        }
        if (data.sequenceNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"sequenceNumber", (long)data.sequenceNumber()));
        }
        if (data.expirationTime() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"expirationTime", Timestamp.JSON, (Object)data.expirationTime()));
        }
        if (data.adminKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"adminKey", Key.JSON, (Object)data.adminKey()));
        }
        if (data.submitKey() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"submitKey", Key.JSON, (Object)data.submitKey()));
        }
        if (data.autoRenewPeriod() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewPeriod", Duration.JSON, (Object)data.autoRenewPeriod()));
        }
        if (data.autoRenewAccount() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"autoRenewAccount", AccountID.JSON, (Object)data.autoRenewAccount()));
        }
        if (data.ledgerId() != Bytes.EMPTY && data.ledgerId() != null && data.ledgerId().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ledgerId", (Bytes)data.ledgerId()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

