/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.ContractNonceInfo;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractFunctionResultProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractFunctionResult(@Nullable ContractID contractID, @NonNull Bytes contractCallResult, String errorMessage, @NonNull Bytes bloom, long gasUsed, @Nullable List<ContractLoginfo> logInfo, @Nullable List<ContractID> createdContractIDs, @Nullable Bytes evmAddress, long gas, long amount, @NonNull Bytes functionParameters, @Nullable AccountID senderId, @Nullable List<ContractNonceInfo> contractNonces, @Nullable Long signerNonce) {
    public static final Codec<ContractFunctionResult> PROTOBUF = new ContractFunctionResultProtoCodec();
    public static final JsonCodec<ContractFunctionResult> JSON = new ContractFunctionResultJsonCodec();
    public static final ContractFunctionResult DEFAULT = ContractFunctionResult.newBuilder().build();

    @Override
    public int hashCode() {
        List<ContractNonceInfo> list;
        List<ContractID> list$createdContractIDs;
        List<ContractLoginfo> list$logInfo;
        int result = 1;
        if (this.contractID != null && !this.contractID.equals(ContractFunctionResult.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.contractCallResult != null && !this.contractCallResult.equals((Object)ContractFunctionResult.DEFAULT.contractCallResult)) {
            result = 31 * result + this.contractCallResult.hashCode();
        }
        if (this.errorMessage != null && !this.errorMessage.equals(ContractFunctionResult.DEFAULT.errorMessage)) {
            result = 31 * result + this.errorMessage.hashCode();
        }
        if (this.bloom != null && !this.bloom.equals((Object)ContractFunctionResult.DEFAULT.bloom)) {
            result = 31 * result + this.bloom.hashCode();
        }
        if (this.gasUsed != ContractFunctionResult.DEFAULT.gasUsed) {
            result = 31 * result + Long.hashCode(this.gasUsed);
        }
        if ((list$logInfo = this.logInfo) != null) {
            for (ContractLoginfo contractLoginfo : list$logInfo) {
                if (contractLoginfo != null) {
                    result = 31 * result + ((Object)contractLoginfo).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if ((list$createdContractIDs = this.createdContractIDs) != null) {
            for (ContractID contractID : list$createdContractIDs) {
                if (contractID != null) {
                    result = 31 * result + ((Object)contractID).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.evmAddress != null && !this.evmAddress.equals((Object)ContractFunctionResult.DEFAULT.evmAddress)) {
            result = 31 * result + (this.evmAddress == null ? 0 : this.evmAddress.hashCode());
        }
        if (this.gas != ContractFunctionResult.DEFAULT.gas) {
            result = 31 * result + Long.hashCode(this.gas);
        }
        if (this.amount != ContractFunctionResult.DEFAULT.amount) {
            result = 31 * result + Long.hashCode(this.amount);
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)ContractFunctionResult.DEFAULT.functionParameters)) {
            result = 31 * result + this.functionParameters.hashCode();
        }
        if (this.senderId != null && !this.senderId.equals(ContractFunctionResult.DEFAULT.senderId)) {
            result = 31 * result + this.senderId.hashCode();
        }
        if ((list = this.contractNonces) != null) {
            for (ContractNonceInfo contractNonceInfo : list) {
                if (contractNonceInfo != null) {
                    result = 31 * result + ((Object)contractNonceInfo).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.signerNonce != null && !this.signerNonce.equals(ContractFunctionResult.DEFAULT.signerNonce)) {
            result = 31 * result + Long.hashCode(this.signerNonce);
        }
        long l = result;
        l += l << 30;
        l ^= l >>> 27;
        l += l << 16;
        l ^= l >>> 20;
        l += l << 5;
        l ^= l >>> 18;
        l += l << 10;
        l ^= l >>> 24;
        l += l << 30;
        return (int)l;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractFunctionResult thatObj = (ContractFunctionResult)that;
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.contractCallResult == null && thatObj.contractCallResult != null) {
            return false;
        }
        if (this.contractCallResult != null && !this.contractCallResult.equals((Object)thatObj.contractCallResult)) {
            return false;
        }
        if (this.errorMessage == null && thatObj.errorMessage != null) {
            return false;
        }
        if (this.errorMessage != null && !this.errorMessage.equals(thatObj.errorMessage)) {
            return false;
        }
        if (this.bloom == null && thatObj.bloom != null) {
            return false;
        }
        if (this.bloom != null && !this.bloom.equals((Object)thatObj.bloom)) {
            return false;
        }
        if (this.gasUsed != thatObj.gasUsed) {
            return false;
        }
        if (this.logInfo == null && thatObj.logInfo != null) {
            return false;
        }
        if (this.logInfo != null && !this.logInfo.equals(thatObj.logInfo)) {
            return false;
        }
        if (this.createdContractIDs == null && thatObj.createdContractIDs != null) {
            return false;
        }
        if (this.createdContractIDs != null && !this.createdContractIDs.equals(thatObj.createdContractIDs)) {
            return false;
        }
        if (this.evmAddress == null && thatObj.evmAddress != null) {
            return false;
        }
        if (this.evmAddress != null && !this.evmAddress.equals((Object)thatObj.evmAddress)) {
            return false;
        }
        if (this.gas != thatObj.gas) {
            return false;
        }
        if (this.amount != thatObj.amount) {
            return false;
        }
        if (this.functionParameters == null && thatObj.functionParameters != null) {
            return false;
        }
        if (this.functionParameters != null && !this.functionParameters.equals((Object)thatObj.functionParameters)) {
            return false;
        }
        if (this.senderId == null && thatObj.senderId != null) {
            return false;
        }
        if (this.senderId != null && !this.senderId.equals(thatObj.senderId)) {
            return false;
        }
        if (this.contractNonces == null && thatObj.contractNonces != null) {
            return false;
        }
        if (this.contractNonces != null && !this.contractNonces.equals(thatObj.contractNonces)) {
            return false;
        }
        if (this.signerNonce == null && thatObj.signerNonce != null) {
            return false;
        }
        return this.signerNonce == null || this.signerNonce.equals(thatObj.signerNonce);
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasLogInfo() {
        return this.logInfo != null;
    }

    public List<ContractLoginfo> logInfoOrElse(@NonNull List<ContractLoginfo> defaultValue) {
        return this.hasLogInfo() ? this.logInfo : defaultValue;
    }

    @NonNull
    public List<ContractLoginfo> logInfoOrThrow() {
        return Objects.requireNonNull(this.logInfo, "Field logInfo is null");
    }

    public void ifLogInfo(@NonNull Consumer<List<ContractLoginfo>> ifPresent) {
        if (this.hasLogInfo()) {
            ifPresent.accept(this.logInfo);
        }
    }

    public boolean hasCreatedContractIDs() {
        return this.createdContractIDs != null;
    }

    public List<ContractID> createdContractIDsOrElse(@NonNull List<ContractID> defaultValue) {
        return this.hasCreatedContractIDs() ? this.createdContractIDs : defaultValue;
    }

    @NonNull
    public List<ContractID> createdContractIDsOrThrow() {
        return Objects.requireNonNull(this.createdContractIDs, "Field createdContractIDs is null");
    }

    public void ifCreatedContractIDs(@NonNull Consumer<List<ContractID>> ifPresent) {
        if (this.hasCreatedContractIDs()) {
            ifPresent.accept(this.createdContractIDs);
        }
    }

    public boolean hasEvmAddress() {
        return this.evmAddress != null;
    }

    public Bytes evmAddressOrElse(@NonNull Bytes defaultValue) {
        return this.hasEvmAddress() ? this.evmAddress : defaultValue;
    }

    @NonNull
    public Bytes evmAddressOrThrow() {
        return Objects.requireNonNull(this.evmAddress, "Field evmAddress is null");
    }

    public void ifEvmAddress(@NonNull Consumer<Bytes> ifPresent) {
        if (this.hasEvmAddress()) {
            ifPresent.accept(this.evmAddress);
        }
    }

    public boolean hasSenderId() {
        return this.senderId != null;
    }

    public AccountID senderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderId() ? this.senderId : defaultValue;
    }

    @NonNull
    public AccountID senderIdOrThrow() {
        return Objects.requireNonNull(this.senderId, "Field senderId is null");
    }

    public void ifSenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderId()) {
            ifPresent.accept(this.senderId);
        }
    }

    public boolean hasContractNonces() {
        return this.contractNonces != null;
    }

    public List<ContractNonceInfo> contractNoncesOrElse(@NonNull List<ContractNonceInfo> defaultValue) {
        return this.hasContractNonces() ? this.contractNonces : defaultValue;
    }

    @NonNull
    public List<ContractNonceInfo> contractNoncesOrThrow() {
        return Objects.requireNonNull(this.contractNonces, "Field contractNonces is null");
    }

    public void ifContractNonces(@NonNull Consumer<List<ContractNonceInfo>> ifPresent) {
        if (this.hasContractNonces()) {
            ifPresent.accept(this.contractNonces);
        }
    }

    public boolean hasSignerNonce() {
        return this.signerNonce != null;
    }

    public Long signerNonceOrElse(@NonNull Long defaultValue) {
        return this.hasSignerNonce() ? this.signerNonce : defaultValue;
    }

    @NonNull
    public Long signerNonceOrThrow() {
        return Objects.requireNonNull(this.signerNonce, "Field signerNonce is null");
    }

    public void ifSignerNonce(@NonNull Consumer<Long> ifPresent) {
        if (this.hasSignerNonce()) {
            ifPresent.accept(this.signerNonce);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces, this.signerNonce);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        @NonNull
        private Bytes contractCallResult = Bytes.EMPTY;
        private String errorMessage = "";
        @NonNull
        private Bytes bloom = Bytes.EMPTY;
        private long gasUsed = 0L;
        @Nullable
        private List<ContractLoginfo> logInfo = Collections.emptyList();
        @Nullable
        private List<ContractID> createdContractIDs = Collections.emptyList();
        @Nullable
        private Bytes evmAddress = null;
        private long gas = 0L;
        private long amount = 0L;
        @NonNull
        private Bytes functionParameters = Bytes.EMPTY;
        @Nullable
        private AccountID senderId = null;
        @Nullable
        private List<ContractNonceInfo> contractNonces = Collections.emptyList();
        @Nullable
        private Long signerNonce = null;

        public Builder() {
        }

        public Builder(ContractID contractID, Bytes contractCallResult, String errorMessage, Bytes bloom, long gasUsed, List<ContractLoginfo> logInfo, List<ContractID> createdContractIDs, Bytes evmAddress, long gas, long amount, Bytes functionParameters, AccountID senderId, List<ContractNonceInfo> contractNonces, Long signerNonce) {
            this.contractID = contractID;
            this.contractCallResult = contractCallResult;
            this.errorMessage = errorMessage;
            this.bloom = bloom;
            this.gasUsed = gasUsed;
            this.logInfo = logInfo;
            this.createdContractIDs = createdContractIDs;
            this.evmAddress = evmAddress;
            this.gas = gas;
            this.amount = amount;
            this.functionParameters = functionParameters;
            this.senderId = senderId;
            this.contractNonces = contractNonces;
            this.signerNonce = signerNonce;
        }

        public ContractFunctionResult build() {
            return new ContractFunctionResult(this.contractID, this.contractCallResult, this.errorMessage, this.bloom, this.gasUsed, this.logInfo, this.createdContractIDs, this.evmAddress, this.gas, this.amount, this.functionParameters, this.senderId, this.contractNonces, this.signerNonce);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder contractCallResult(@NonNull Bytes contractCallResult) {
            this.contractCallResult = contractCallResult != null ? contractCallResult : Bytes.EMPTY;
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public Builder bloom(@NonNull Bytes bloom) {
            this.bloom = bloom != null ? bloom : Bytes.EMPTY;
            return this;
        }

        public Builder gasUsed(long gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public Builder logInfo(@Nullable List<ContractLoginfo> logInfo) {
            this.logInfo = logInfo;
            return this;
        }

        public Builder logInfo(ContractLoginfo ... values) {
            this.logInfo = List.of(values);
            return this;
        }

        public Builder createdContractIDs(@Nullable List<ContractID> createdContractIDs) {
            this.createdContractIDs = createdContractIDs;
            return this;
        }

        public Builder createdContractIDs(ContractID ... values) {
            this.createdContractIDs = List.of(values);
            return this;
        }

        public Builder evmAddress(@Nullable Bytes evmAddress) {
            this.evmAddress = evmAddress;
            return this;
        }

        public Builder gas(long gas) {
            this.gas = gas;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder functionParameters(@NonNull Bytes functionParameters) {
            this.functionParameters = functionParameters != null ? functionParameters : Bytes.EMPTY;
            return this;
        }

        public Builder senderId(@Nullable AccountID senderId) {
            this.senderId = senderId;
            return this;
        }

        public Builder senderId(AccountID.Builder builder) {
            this.senderId = builder.build();
            return this;
        }

        public Builder contractNonces(@Nullable List<ContractNonceInfo> contractNonces) {
            this.contractNonces = contractNonces;
            return this;
        }

        public Builder contractNonces(ContractNonceInfo ... values) {
            this.contractNonces = List.of(values);
            return this;
        }

        public Builder signerNonce(@Nullable Long signerNonce) {
            this.signerNonce = signerNonce;
            return this;
        }
    }
}

