/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.contract.codec.ContractInfoJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractInfo(@Nullable ContractID contractID, @Nullable AccountID accountID, String contractAccountID, @Nullable Key adminKey, @Nullable Timestamp expirationTime, @Nullable Duration autoRenewPeriod, long storage, String memo, long balance, boolean deleted, @Nullable List<TokenRelationship> tokenRelationships, @NonNull Bytes ledgerId, @Nullable AccountID autoRenewAccountId, int maxAutomaticTokenAssociations, @Nullable StakingInfo stakingInfo) {
    public static final Codec<ContractInfo> PROTOBUF = new ContractInfoProtoCodec();
    public static final JsonCodec<ContractInfo> JSON = new ContractInfoJsonCodec();
    public static final ContractInfo DEFAULT = ContractInfo.newBuilder().build();

    @Override
    public int hashCode() {
        List<TokenRelationship> list$tokenRelationships;
        int result = 1;
        if (this.contractID != null && !this.contractID.equals(ContractInfo.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.accountID != null && !this.accountID.equals(ContractInfo.DEFAULT.accountID)) {
            result = 31 * result + this.accountID.hashCode();
        }
        if (this.contractAccountID != null && !this.contractAccountID.equals(ContractInfo.DEFAULT.contractAccountID)) {
            result = 31 * result + this.contractAccountID.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(ContractInfo.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.expirationTime != null && !this.expirationTime.equals(ContractInfo.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(ContractInfo.DEFAULT.autoRenewPeriod)) {
            result = 31 * result + this.autoRenewPeriod.hashCode();
        }
        if (this.storage != ContractInfo.DEFAULT.storage) {
            result = 31 * result + Long.hashCode(this.storage);
        }
        if (this.memo != null && !this.memo.equals(ContractInfo.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.balance != ContractInfo.DEFAULT.balance) {
            result = 31 * result + Long.hashCode(this.balance);
        }
        if (this.deleted != ContractInfo.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if ((list$tokenRelationships = this.tokenRelationships) != null) {
            for (TokenRelationship o : list$tokenRelationships) {
                if (o != null) {
                    result = 31 * result + ((Object)o).hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)ContractInfo.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(ContractInfo.DEFAULT.autoRenewAccountId)) {
            result = 31 * result + this.autoRenewAccountId.hashCode();
        }
        if (this.maxAutomaticTokenAssociations != ContractInfo.DEFAULT.maxAutomaticTokenAssociations) {
            result = 31 * result + Integer.hashCode(this.maxAutomaticTokenAssociations);
        }
        if (this.stakingInfo != null && !this.stakingInfo.equals(ContractInfo.DEFAULT.stakingInfo)) {
            result = 31 * result + this.stakingInfo.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractInfo thatObj = (ContractInfo)that;
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.accountID == null && thatObj.accountID != null) {
            return false;
        }
        if (this.accountID != null && !this.accountID.equals(thatObj.accountID)) {
            return false;
        }
        if (this.contractAccountID == null && thatObj.contractAccountID != null) {
            return false;
        }
        if (this.contractAccountID != null && !this.contractAccountID.equals(thatObj.contractAccountID)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.autoRenewPeriod == null && thatObj.autoRenewPeriod != null) {
            return false;
        }
        if (this.autoRenewPeriod != null && !this.autoRenewPeriod.equals(thatObj.autoRenewPeriod)) {
            return false;
        }
        if (this.storage != thatObj.storage) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.balance != thatObj.balance) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.tokenRelationships == null && thatObj.tokenRelationships != null) {
            return false;
        }
        if (this.tokenRelationships != null && !this.tokenRelationships.equals(thatObj.tokenRelationships)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)thatObj.ledgerId)) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.maxAutomaticTokenAssociations != thatObj.maxAutomaticTokenAssociations) {
            return false;
        }
        if (this.stakingInfo == null && thatObj.stakingInfo != null) {
            return false;
        }
        return this.stakingInfo == null || this.stakingInfo.equals(thatObj.stakingInfo);
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasAutoRenewPeriod() {
        return this.autoRenewPeriod != null;
    }

    public Duration autoRenewPeriodOrElse(@NonNull Duration defaultValue) {
        return this.hasAutoRenewPeriod() ? this.autoRenewPeriod : defaultValue;
    }

    @NonNull
    public Duration autoRenewPeriodOrThrow() {
        return Objects.requireNonNull(this.autoRenewPeriod, "Field autoRenewPeriod is null");
    }

    public void ifAutoRenewPeriod(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasAutoRenewPeriod()) {
            ifPresent.accept(this.autoRenewPeriod);
        }
    }

    public boolean hasTokenRelationships() {
        return this.tokenRelationships != null;
    }

    public List<TokenRelationship> tokenRelationshipsOrElse(@NonNull List<TokenRelationship> defaultValue) {
        return this.hasTokenRelationships() ? this.tokenRelationships : defaultValue;
    }

    @NonNull
    public List<TokenRelationship> tokenRelationshipsOrThrow() {
        return Objects.requireNonNull(this.tokenRelationships, "Field tokenRelationships is null");
    }

    public void ifTokenRelationships(@NonNull Consumer<List<TokenRelationship>> ifPresent) {
        if (this.hasTokenRelationships()) {
            ifPresent.accept(this.tokenRelationships);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasStakingInfo() {
        return this.stakingInfo != null;
    }

    public StakingInfo stakingInfoOrElse(@NonNull StakingInfo defaultValue) {
        return this.hasStakingInfo() ? this.stakingInfo : defaultValue;
    }

    @NonNull
    public StakingInfo stakingInfoOrThrow() {
        return Objects.requireNonNull(this.stakingInfo, "Field stakingInfo is null");
    }

    public void ifStakingInfo(@NonNull Consumer<StakingInfo> ifPresent) {
        if (this.hasStakingInfo()) {
            ifPresent.accept(this.stakingInfo);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.accountID, this.contractAccountID, this.adminKey, this.expirationTime, this.autoRenewPeriod, this.storage, this.memo, this.balance, this.deleted, this.tokenRelationships, this.ledgerId, this.autoRenewAccountId, this.maxAutomaticTokenAssociations, this.stakingInfo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        @Nullable
        private AccountID accountID = null;
        private String contractAccountID = "";
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private Duration autoRenewPeriod = null;
        private long storage = 0L;
        private String memo = "";
        private long balance = 0L;
        private boolean deleted = false;
        @Nullable
        private List<TokenRelationship> tokenRelationships = Collections.emptyList();
        @NonNull
        private Bytes ledgerId = Bytes.EMPTY;
        @Nullable
        private AccountID autoRenewAccountId = null;
        private int maxAutomaticTokenAssociations = 0;
        @Nullable
        private StakingInfo stakingInfo = null;

        public Builder() {
        }

        public Builder(ContractID contractID, AccountID accountID, String contractAccountID, Key adminKey, Timestamp expirationTime, Duration autoRenewPeriod, long storage, String memo, long balance, boolean deleted, List<TokenRelationship> tokenRelationships, Bytes ledgerId, AccountID autoRenewAccountId, int maxAutomaticTokenAssociations, StakingInfo stakingInfo) {
            this.contractID = contractID;
            this.accountID = accountID;
            this.contractAccountID = contractAccountID;
            this.adminKey = adminKey;
            this.expirationTime = expirationTime;
            this.autoRenewPeriod = autoRenewPeriod;
            this.storage = storage;
            this.memo = memo;
            this.balance = balance;
            this.deleted = deleted;
            this.tokenRelationships = tokenRelationships;
            this.ledgerId = ledgerId;
            this.autoRenewAccountId = autoRenewAccountId;
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            this.stakingInfo = stakingInfo;
        }

        public ContractInfo build() {
            return new ContractInfo(this.contractID, this.accountID, this.contractAccountID, this.adminKey, this.expirationTime, this.autoRenewPeriod, this.storage, this.memo, this.balance, this.deleted, this.tokenRelationships, this.ledgerId, this.autoRenewAccountId, this.maxAutomaticTokenAssociations, this.stakingInfo);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder accountID(@Nullable AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder contractAccountID(String contractAccountID) {
            this.contractAccountID = contractAccountID;
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder autoRenewPeriod(@Nullable Duration autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewPeriod(Duration.Builder builder) {
            this.autoRenewPeriod = builder.build();
            return this;
        }

        public Builder storage(long storage) {
            this.storage = storage;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder tokenRelationships(@Nullable List<TokenRelationship> tokenRelationships) {
            this.tokenRelationships = tokenRelationships;
            return this;
        }

        public Builder tokenRelationships(TokenRelationship ... values) {
            this.tokenRelationships = List.of(values);
            return this;
        }

        public Builder ledgerId(@NonNull Bytes ledgerId) {
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder maxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
            this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
            return this;
        }

        public Builder stakingInfo(@Nullable StakingInfo stakingInfo) {
            this.stakingInfo = stakingInfo;
            return this;
        }

        public Builder stakingInfo(StakingInfo.Builder builder) {
            this.stakingInfo = builder.build();
            return this;
        }
    }
}

