/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractLoginfoJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractLoginfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractLoginfo(@Nullable ContractID contractID, @NonNull Bytes bloom, @NonNull List<Bytes> topic, @NonNull Bytes data) {
    public static final Codec<ContractLoginfo> PROTOBUF = new ContractLoginfoProtoCodec();
    public static final JsonCodec<ContractLoginfo> JSON = new ContractLoginfoJsonCodec();
    public static final ContractLoginfo DEFAULT = ContractLoginfo.newBuilder().build();

    @Override
    public int hashCode() {
        List<Bytes> list$topic;
        int result = 1;
        if (this.contractID != null && !this.contractID.equals(ContractLoginfo.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.bloom != null && !this.bloom.equals((Object)ContractLoginfo.DEFAULT.bloom)) {
            result = 31 * result + this.bloom.hashCode();
        }
        if ((list$topic = this.topic) != null) {
            for (Bytes o : list$topic) {
                if (o != null) {
                    result = 31 * result + o.hashCode();
                    continue;
                }
                result = 31 * result;
            }
        }
        if (this.data != null && !this.data.equals((Object)ContractLoginfo.DEFAULT.data)) {
            result = 31 * result + this.data.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractLoginfo thatObj = (ContractLoginfo)that;
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.bloom == null && thatObj.bloom != null) {
            return false;
        }
        if (this.bloom != null && !this.bloom.equals((Object)thatObj.bloom)) {
            return false;
        }
        if (this.topic == null && thatObj.topic != null) {
            return false;
        }
        if (this.topic != null && !this.topic.equals(thatObj.topic)) {
            return false;
        }
        if (this.data == null && thatObj.data != null) {
            return false;
        }
        return this.data == null || this.data.equals((Object)thatObj.data);
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.bloom, this.topic, this.data);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        @NonNull
        private Bytes bloom = Bytes.EMPTY;
        @NonNull
        private List<Bytes> topic = Collections.emptyList();
        @NonNull
        private Bytes data = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(ContractID contractID, Bytes bloom, List<Bytes> topic, Bytes data) {
            this.contractID = contractID;
            this.bloom = bloom;
            this.topic = topic;
            this.data = data;
        }

        public ContractLoginfo build() {
            return new ContractLoginfo(this.contractID, this.bloom, this.topic, this.data);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder bloom(@NonNull Bytes bloom) {
            this.bloom = bloom != null ? bloom : Bytes.EMPTY;
            return this;
        }

        public Builder topic(@NonNull List<Bytes> topic) {
            this.topic = topic != null ? topic : Collections.emptyList();
            return this;
        }

        public Builder topic(Bytes ... values) {
            this.topic = List.of(values) != null ? this.topic : Collections.emptyList();
            return this;
        }

        public Builder data(@NonNull Bytes data) {
            this.data = data != null ? data : Bytes.EMPTY;
            return this;
        }
    }
}

