/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.codec.ContractNonceInfoJsonCodec;
import com.hedera.hapi.node.contract.codec.ContractNonceInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ContractNonceInfo(@Nullable ContractID contractId, long nonce) {
    public static final Codec<ContractNonceInfo> PROTOBUF = new ContractNonceInfoProtoCodec();
    public static final JsonCodec<ContractNonceInfo> JSON = new ContractNonceInfoJsonCodec();
    public static final ContractNonceInfo DEFAULT = ContractNonceInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.contractId != null && !this.contractId.equals(ContractNonceInfo.DEFAULT.contractId)) {
            result = 31 * result + this.contractId.hashCode();
        }
        if (this.nonce != ContractNonceInfo.DEFAULT.nonce) {
            result = 31 * result + Long.hashCode(this.nonce);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        ContractNonceInfo thatObj = (ContractNonceInfo)that;
        if (this.contractId == null && thatObj.contractId != null) {
            return false;
        }
        if (this.contractId != null && !this.contractId.equals(thatObj.contractId)) {
            return false;
        }
        return this.nonce == thatObj.nonce;
    }

    public boolean hasContractId() {
        return this.contractId != null;
    }

    public ContractID contractIdOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractId() ? this.contractId : defaultValue;
    }

    @NonNull
    public ContractID contractIdOrThrow() {
        return Objects.requireNonNull(this.contractId, "Field contractId is null");
    }

    public void ifContractId(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractId()) {
            ifPresent.accept(this.contractId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractId, this.nonce);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractId = null;
        private long nonce = 0L;

        public Builder() {
        }

        public Builder(ContractID contractId, long nonce) {
            this.contractId = contractId;
            this.nonce = nonce;
        }

        public ContractNonceInfo build() {
            return new ContractNonceInfo(this.contractId, this.nonce);
        }

        public Builder contractId(@Nullable ContractID contractId) {
            this.contractId = contractId;
            return this;
        }

        public Builder contractId(ContractID.Builder builder) {
            this.contractId = builder.build();
            return this;
        }

        public Builder nonce(long nonce) {
            this.nonce = nonce;
            return this;
        }
    }
}

