/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyJsonCodec;
import com.hedera.hapi.node.contract.codec.EthereumTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record EthereumTransactionBody(@NonNull Bytes ethereumData, @Nullable FileID callData, long maxGasAllowance) {
    public static final Codec<EthereumTransactionBody> PROTOBUF = new EthereumTransactionBodyProtoCodec();
    public static final JsonCodec<EthereumTransactionBody> JSON = new EthereumTransactionBodyJsonCodec();
    public static final EthereumTransactionBody DEFAULT = EthereumTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.ethereumData != null && !this.ethereumData.equals((Object)EthereumTransactionBody.DEFAULT.ethereumData)) {
            result = 31 * result + this.ethereumData.hashCode();
        }
        if (this.callData != null && !this.callData.equals(EthereumTransactionBody.DEFAULT.callData)) {
            result = 31 * result + this.callData.hashCode();
        }
        if (this.maxGasAllowance != EthereumTransactionBody.DEFAULT.maxGasAllowance) {
            result = 31 * result + Long.hashCode(this.maxGasAllowance);
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        EthereumTransactionBody thatObj = (EthereumTransactionBody)that;
        if (this.ethereumData == null && thatObj.ethereumData != null) {
            return false;
        }
        if (this.ethereumData != null && !this.ethereumData.equals((Object)thatObj.ethereumData)) {
            return false;
        }
        if (this.callData == null && thatObj.callData != null) {
            return false;
        }
        if (this.callData != null && !this.callData.equals(thatObj.callData)) {
            return false;
        }
        return this.maxGasAllowance == thatObj.maxGasAllowance;
    }

    public boolean hasCallData() {
        return this.callData != null;
    }

    public FileID callDataOrElse(@NonNull FileID defaultValue) {
        return this.hasCallData() ? this.callData : defaultValue;
    }

    @NonNull
    public FileID callDataOrThrow() {
        return Objects.requireNonNull(this.callData, "Field callData is null");
    }

    public void ifCallData(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasCallData()) {
            ifPresent.accept(this.callData);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.ethereumData, this.callData, this.maxGasAllowance);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @NonNull
        private Bytes ethereumData = Bytes.EMPTY;
        @Nullable
        private FileID callData = null;
        private long maxGasAllowance = 0L;

        public Builder() {
        }

        public Builder(Bytes ethereumData, FileID callData, long maxGasAllowance) {
            this.ethereumData = ethereumData;
            this.callData = callData;
            this.maxGasAllowance = maxGasAllowance;
        }

        public EthereumTransactionBody build() {
            return new EthereumTransactionBody(this.ethereumData, this.callData, this.maxGasAllowance);
        }

        public Builder ethereumData(@NonNull Bytes ethereumData) {
            this.ethereumData = ethereumData != null ? ethereumData : Bytes.EMPTY;
            return this;
        }

        public Builder callData(@Nullable FileID callData) {
            this.callData = callData;
            return this;
        }

        public Builder callData(FileID.Builder builder) {
            this.callData = builder.build();
            return this;
        }

        public Builder maxGasAllowance(long maxGasAllowance) {
            this.maxGasAllowance = maxGasAllowance;
            return this;
        }
    }
}

