/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.contract.schema.ContractLoginfoSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContractLoginfoJsonCodec
implements JsonCodec<ContractLoginfo> {
    @NonNull
    public ContractLoginfo parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            ContractID temp_contractID = null;
            Bytes temp_bloom = Bytes.EMPTY;
            List<Bytes> temp_topic = Collections.emptyList();
            Bytes temp_data = Bytes.EMPTY;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "contractID": {
                        temp_contractID = (ContractID)ContractID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block14;
                    }
                    case "bloom": {
                        temp_bloom = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "topic": {
                        temp_topic = kvPair.value().arr().value().stream().map(v -> Bytes.fromBase64((String)v.STRING().getText())).toList();
                        continue block14;
                    }
                    case "data": {
                        temp_data = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ContractLoginfo(temp_contractID, temp_bloom, temp_topic, temp_data);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ContractLoginfo data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.contractID() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"contractID", ContractID.JSON, (Object)data.contractID()));
        }
        if (data.bloom() != Bytes.EMPTY && data.bloom() != null && data.bloom().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"bloom", (Bytes)data.bloom()));
        }
        if (!data.topic().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"topic", (FieldDefinition)ContractLoginfoSchema.TOPIC, data.topic()));
        }
        if (data.data() != Bytes.EMPTY && data.data() != null && data.data().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"data", (Bytes)data.data()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

