/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.contract.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.contract.EthereumTransactionBody;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class EthereumTransactionBodyJsonCodec
implements JsonCodec<EthereumTransactionBody> {
    @NonNull
    public EthereumTransactionBody parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws ParseException {
        try {
            Bytes temp_ethereum_data = Bytes.EMPTY;
            FileID temp_call_data = null;
            long temp_max_gas_allowance = 0L;
            block12: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "ethereumData": {
                        temp_ethereum_data = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block12;
                    }
                    case "callData": {
                        temp_call_data = (FileID)FileID.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false);
                        continue block12;
                    }
                    case "maxGasAllowance": {
                        temp_max_gas_allowance = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block12;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EthereumTransactionBody(temp_ethereum_data, temp_call_data, temp_max_gas_allowance);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EthereumTransactionBody data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.ethereumData() != Bytes.EMPTY && data.ethereumData() != null && data.ethereumData().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"ethereumData", (Bytes)data.ethereumData()));
        }
        if (data.callData() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"callData", FileID.JSON, (Object)data.callData()));
        }
        if (data.maxGasAllowance() != 0L) {
            fieldLines.add(JsonTools.field((String)"maxGasAllowance", (long)data.maxGasAllowance()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

