/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.file.codec.FileContentsJsonCodec;
import com.hedera.hapi.node.file.codec.FileContentsProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileContents(@Nullable FileID fileID, @NonNull Bytes contents) {
    public static final Codec<FileContents> PROTOBUF = new FileContentsProtoCodec();
    public static final JsonCodec<FileContents> JSON = new FileContentsJsonCodec();
    public static final FileContents DEFAULT = FileContents.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fileID != null && !this.fileID.equals(FileContents.DEFAULT.fileID)) {
            result = 31 * result + this.fileID.hashCode();
        }
        if (this.contents != null && !this.contents.equals((Object)FileContents.DEFAULT.contents)) {
            result = 31 * result + this.contents.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FileContents thatObj = (FileContents)that;
        if (this.fileID == null && thatObj.fileID != null) {
            return false;
        }
        if (this.fileID != null && !this.fileID.equals(thatObj.fileID)) {
            return false;
        }
        if (this.contents == null && thatObj.contents != null) {
            return false;
        }
        return this.contents == null || this.contents.equals((Object)thatObj.contents);
    }

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.contents);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private FileID fileID = null;
        @NonNull
        private Bytes contents = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(FileID fileID, Bytes contents) {
            this.fileID = fileID;
            this.contents = contents;
        }

        public FileContents build() {
            return new FileContents(this.fileID, this.contents);
        }

        public Builder fileID(@Nullable FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder contents(@NonNull Bytes contents) {
            this.contents = contents != null ? contents : Bytes.EMPTY;
            return this;
        }
    }
}

