/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.RealmID;
import com.hedera.hapi.node.base.ShardID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.FileCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileCreateTransactionBody(@Nullable Timestamp expirationTime, @Nullable KeyList keys, @NonNull Bytes contents, @Nullable ShardID shardID, @Nullable RealmID realmID, @Nullable Key newRealmAdminKey, String memo) {
    public static final Codec<FileCreateTransactionBody> PROTOBUF = new FileCreateTransactionBodyProtoCodec();
    public static final JsonCodec<FileCreateTransactionBody> JSON = new FileCreateTransactionBodyJsonCodec();
    public static final FileCreateTransactionBody DEFAULT = FileCreateTransactionBody.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.expirationTime != null && !this.expirationTime.equals(FileCreateTransactionBody.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.keys != null && !this.keys.equals(FileCreateTransactionBody.DEFAULT.keys)) {
            result = 31 * result + this.keys.hashCode();
        }
        if (this.contents != null && !this.contents.equals((Object)FileCreateTransactionBody.DEFAULT.contents)) {
            result = 31 * result + this.contents.hashCode();
        }
        if (this.shardID != null && !this.shardID.equals(FileCreateTransactionBody.DEFAULT.shardID)) {
            result = 31 * result + this.shardID.hashCode();
        }
        if (this.realmID != null && !this.realmID.equals(FileCreateTransactionBody.DEFAULT.realmID)) {
            result = 31 * result + this.realmID.hashCode();
        }
        if (this.newRealmAdminKey != null && !this.newRealmAdminKey.equals(FileCreateTransactionBody.DEFAULT.newRealmAdminKey)) {
            result = 31 * result + this.newRealmAdminKey.hashCode();
        }
        if (this.memo != null && !this.memo.equals(FileCreateTransactionBody.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FileCreateTransactionBody thatObj = (FileCreateTransactionBody)that;
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.contents == null && thatObj.contents != null) {
            return false;
        }
        if (this.contents != null && !this.contents.equals((Object)thatObj.contents)) {
            return false;
        }
        if (this.shardID == null && thatObj.shardID != null) {
            return false;
        }
        if (this.shardID != null && !this.shardID.equals(thatObj.shardID)) {
            return false;
        }
        if (this.realmID == null && thatObj.realmID != null) {
            return false;
        }
        if (this.realmID != null && !this.realmID.equals(thatObj.realmID)) {
            return false;
        }
        if (this.newRealmAdminKey == null && thatObj.newRealmAdminKey != null) {
            return false;
        }
        if (this.newRealmAdminKey != null && !this.newRealmAdminKey.equals(thatObj.newRealmAdminKey)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        return this.memo == null || this.memo.equals(thatObj.memo);
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasShardID() {
        return this.shardID != null;
    }

    public ShardID shardIDOrElse(@NonNull ShardID defaultValue) {
        return this.hasShardID() ? this.shardID : defaultValue;
    }

    @NonNull
    public ShardID shardIDOrThrow() {
        return Objects.requireNonNull(this.shardID, "Field shardID is null");
    }

    public void ifShardID(@NonNull Consumer<ShardID> ifPresent) {
        if (this.hasShardID()) {
            ifPresent.accept(this.shardID);
        }
    }

    public boolean hasRealmID() {
        return this.realmID != null;
    }

    public RealmID realmIDOrElse(@NonNull RealmID defaultValue) {
        return this.hasRealmID() ? this.realmID : defaultValue;
    }

    @NonNull
    public RealmID realmIDOrThrow() {
        return Objects.requireNonNull(this.realmID, "Field realmID is null");
    }

    public void ifRealmID(@NonNull Consumer<RealmID> ifPresent) {
        if (this.hasRealmID()) {
            ifPresent.accept(this.realmID);
        }
    }

    public boolean hasNewRealmAdminKey() {
        return this.newRealmAdminKey != null;
    }

    public Key newRealmAdminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasNewRealmAdminKey() ? this.newRealmAdminKey : defaultValue;
    }

    @NonNull
    public Key newRealmAdminKeyOrThrow() {
        return Objects.requireNonNull(this.newRealmAdminKey, "Field newRealmAdminKey is null");
    }

    public void ifNewRealmAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasNewRealmAdminKey()) {
            ifPresent.accept(this.newRealmAdminKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Timestamp expirationTime = null;
        @Nullable
        private KeyList keys = null;
        @NonNull
        private Bytes contents = Bytes.EMPTY;
        @Nullable
        private ShardID shardID = null;
        @Nullable
        private RealmID realmID = null;
        @Nullable
        private Key newRealmAdminKey = null;
        private String memo = "";

        public Builder() {
        }

        public Builder(Timestamp expirationTime, KeyList keys, Bytes contents, ShardID shardID, RealmID realmID, Key newRealmAdminKey, String memo) {
            this.expirationTime = expirationTime;
            this.keys = keys;
            this.contents = contents;
            this.shardID = shardID;
            this.realmID = realmID;
            this.newRealmAdminKey = newRealmAdminKey;
            this.memo = memo;
        }

        public FileCreateTransactionBody build() {
            return new FileCreateTransactionBody(this.expirationTime, this.keys, this.contents, this.shardID, this.realmID, this.newRealmAdminKey, this.memo);
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder keys(@Nullable KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(@NonNull Bytes contents) {
            this.contents = contents != null ? contents : Bytes.EMPTY;
            return this;
        }

        public Builder shardID(@Nullable ShardID shardID) {
            this.shardID = shardID;
            return this;
        }

        public Builder shardID(ShardID.Builder builder) {
            this.shardID = builder.build();
            return this;
        }

        public Builder realmID(@Nullable RealmID realmID) {
            this.realmID = realmID;
            return this;
        }

        public Builder realmID(RealmID.Builder builder) {
            this.realmID = builder.build();
            return this;
        }

        public Builder newRealmAdminKey(@Nullable Key newRealmAdminKey) {
            this.newRealmAdminKey = newRealmAdminKey;
            return this;
        }

        public Builder newRealmAdminKey(Key.Builder builder) {
            this.newRealmAdminKey = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }
    }
}

