/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileInfoJsonCodec;
import com.hedera.hapi.node.file.codec.FileInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileInfo(@Nullable FileID fileID, long size, @Nullable Timestamp expirationTime, boolean deleted, @Nullable KeyList keys, String memo, @NonNull Bytes ledgerId) {
    public static final Codec<FileInfo> PROTOBUF = new FileInfoProtoCodec();
    public static final JsonCodec<FileInfo> JSON = new FileInfoJsonCodec();
    public static final FileInfo DEFAULT = FileInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.fileID != null && !this.fileID.equals(FileInfo.DEFAULT.fileID)) {
            result = 31 * result + this.fileID.hashCode();
        }
        if (this.size != FileInfo.DEFAULT.size) {
            result = 31 * result + Long.hashCode(this.size);
        }
        if (this.expirationTime != null && !this.expirationTime.equals(FileInfo.DEFAULT.expirationTime)) {
            result = 31 * result + this.expirationTime.hashCode();
        }
        if (this.deleted != FileInfo.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.keys != null && !this.keys.equals(FileInfo.DEFAULT.keys)) {
            result = 31 * result + this.keys.hashCode();
        }
        if (this.memo != null && !this.memo.equals(FileInfo.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.ledgerId != null && !this.ledgerId.equals((Object)FileInfo.DEFAULT.ledgerId)) {
            result = 31 * result + this.ledgerId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        FileInfo thatObj = (FileInfo)that;
        if (this.fileID == null && thatObj.fileID != null) {
            return false;
        }
        if (this.fileID != null && !this.fileID.equals(thatObj.fileID)) {
            return false;
        }
        if (this.size != thatObj.size) {
            return false;
        }
        if (this.expirationTime == null && thatObj.expirationTime != null) {
            return false;
        }
        if (this.expirationTime != null && !this.expirationTime.equals(thatObj.expirationTime)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.keys == null && thatObj.keys != null) {
            return false;
        }
        if (this.keys != null && !this.keys.equals(thatObj.keys)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.ledgerId == null && thatObj.ledgerId != null) {
            return false;
        }
        return this.ledgerId == null || this.ledgerId.equals((Object)thatObj.ledgerId);
    }

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.size, this.expirationTime, this.deleted, this.keys, this.memo, this.ledgerId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private FileID fileID = null;
        private long size = 0L;
        @Nullable
        private Timestamp expirationTime = null;
        private boolean deleted = false;
        @Nullable
        private KeyList keys = null;
        private String memo = "";
        @NonNull
        private Bytes ledgerId = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(FileID fileID, long size, Timestamp expirationTime, boolean deleted, KeyList keys, String memo, Bytes ledgerId) {
            this.fileID = fileID;
            this.size = size;
            this.expirationTime = expirationTime;
            this.deleted = deleted;
            this.keys = keys;
            this.memo = memo;
            this.ledgerId = ledgerId;
        }

        public FileInfo build() {
            return new FileInfo(this.fileID, this.size, this.expirationTime, this.deleted, this.keys, this.memo, this.ledgerId);
        }

        public Builder fileID(@Nullable FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder size(long size) {
            this.size = size;
            return this;
        }

        public Builder expirationTime(@Nullable Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder keys(@Nullable KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder ledgerId(@NonNull Bytes ledgerId) {
            this.ledgerId = ledgerId != null ? ledgerId : Bytes.EMPTY;
            return this;
        }
    }
}

