/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.blockrecords;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoJsonCodec;
import com.hedera.hapi.node.state.blockrecords.codec.BlockInfoProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record BlockInfo(long lastBlockNumber, @Nullable Timestamp firstConsTimeOfLastBlock, @NonNull Bytes blockHashes, @Nullable Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, @Nullable Timestamp firstConsTimeOfCurrentBlock) {
    public static final Codec<BlockInfo> PROTOBUF = new BlockInfoProtoCodec();
    public static final JsonCodec<BlockInfo> JSON = new BlockInfoJsonCodec();
    public static final BlockInfo DEFAULT = BlockInfo.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.lastBlockNumber != BlockInfo.DEFAULT.lastBlockNumber) {
            result = 31 * result + Long.hashCode(this.lastBlockNumber);
        }
        if (this.firstConsTimeOfLastBlock != null && !this.firstConsTimeOfLastBlock.equals(BlockInfo.DEFAULT.firstConsTimeOfLastBlock)) {
            result = 31 * result + this.firstConsTimeOfLastBlock.hashCode();
        }
        if (this.blockHashes != null && !this.blockHashes.equals((Object)BlockInfo.DEFAULT.blockHashes)) {
            result = 31 * result + this.blockHashes.hashCode();
        }
        if (this.consTimeOfLastHandledTxn != null && !this.consTimeOfLastHandledTxn.equals(BlockInfo.DEFAULT.consTimeOfLastHandledTxn)) {
            result = 31 * result + this.consTimeOfLastHandledTxn.hashCode();
        }
        if (this.migrationRecordsStreamed != BlockInfo.DEFAULT.migrationRecordsStreamed) {
            result = 31 * result + Boolean.hashCode(this.migrationRecordsStreamed);
        }
        if (this.firstConsTimeOfCurrentBlock != null && !this.firstConsTimeOfCurrentBlock.equals(BlockInfo.DEFAULT.firstConsTimeOfCurrentBlock)) {
            result = 31 * result + this.firstConsTimeOfCurrentBlock.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockInfo thatObj = (BlockInfo)that;
        if (this.lastBlockNumber != thatObj.lastBlockNumber) {
            return false;
        }
        if (this.firstConsTimeOfLastBlock == null && thatObj.firstConsTimeOfLastBlock != null) {
            return false;
        }
        if (this.firstConsTimeOfLastBlock != null && !this.firstConsTimeOfLastBlock.equals(thatObj.firstConsTimeOfLastBlock)) {
            return false;
        }
        if (this.blockHashes == null && thatObj.blockHashes != null) {
            return false;
        }
        if (this.blockHashes != null && !this.blockHashes.equals((Object)thatObj.blockHashes)) {
            return false;
        }
        if (this.consTimeOfLastHandledTxn == null && thatObj.consTimeOfLastHandledTxn != null) {
            return false;
        }
        if (this.consTimeOfLastHandledTxn != null && !this.consTimeOfLastHandledTxn.equals(thatObj.consTimeOfLastHandledTxn)) {
            return false;
        }
        if (this.migrationRecordsStreamed != thatObj.migrationRecordsStreamed) {
            return false;
        }
        if (this.firstConsTimeOfCurrentBlock == null && thatObj.firstConsTimeOfCurrentBlock != null) {
            return false;
        }
        return this.firstConsTimeOfCurrentBlock == null || this.firstConsTimeOfCurrentBlock.equals(thatObj.firstConsTimeOfCurrentBlock);
    }

    public boolean hasFirstConsTimeOfLastBlock() {
        return this.firstConsTimeOfLastBlock != null;
    }

    public Timestamp firstConsTimeOfLastBlockOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFirstConsTimeOfLastBlock() ? this.firstConsTimeOfLastBlock : defaultValue;
    }

    @NonNull
    public Timestamp firstConsTimeOfLastBlockOrThrow() {
        return Objects.requireNonNull(this.firstConsTimeOfLastBlock, "Field firstConsTimeOfLastBlock is null");
    }

    public void ifFirstConsTimeOfLastBlock(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFirstConsTimeOfLastBlock()) {
            ifPresent.accept(this.firstConsTimeOfLastBlock);
        }
    }

    public boolean hasConsTimeOfLastHandledTxn() {
        return this.consTimeOfLastHandledTxn != null;
    }

    public Timestamp consTimeOfLastHandledTxnOrElse(@NonNull Timestamp defaultValue) {
        return this.hasConsTimeOfLastHandledTxn() ? this.consTimeOfLastHandledTxn : defaultValue;
    }

    @NonNull
    public Timestamp consTimeOfLastHandledTxnOrThrow() {
        return Objects.requireNonNull(this.consTimeOfLastHandledTxn, "Field consTimeOfLastHandledTxn is null");
    }

    public void ifConsTimeOfLastHandledTxn(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasConsTimeOfLastHandledTxn()) {
            ifPresent.accept(this.consTimeOfLastHandledTxn);
        }
    }

    public boolean hasFirstConsTimeOfCurrentBlock() {
        return this.firstConsTimeOfCurrentBlock != null;
    }

    public Timestamp firstConsTimeOfCurrentBlockOrElse(@NonNull Timestamp defaultValue) {
        return this.hasFirstConsTimeOfCurrentBlock() ? this.firstConsTimeOfCurrentBlock : defaultValue;
    }

    @NonNull
    public Timestamp firstConsTimeOfCurrentBlockOrThrow() {
        return Objects.requireNonNull(this.firstConsTimeOfCurrentBlock, "Field firstConsTimeOfCurrentBlock is null");
    }

    public void ifFirstConsTimeOfCurrentBlock(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasFirstConsTimeOfCurrentBlock()) {
            ifPresent.accept(this.firstConsTimeOfCurrentBlock);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes, this.consTimeOfLastHandledTxn, this.migrationRecordsStreamed, this.firstConsTimeOfCurrentBlock);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long lastBlockNumber = 0L;
        @Nullable
        private Timestamp firstConsTimeOfLastBlock = null;
        @NonNull
        private Bytes blockHashes = Bytes.EMPTY;
        @Nullable
        private Timestamp consTimeOfLastHandledTxn = null;
        private boolean migrationRecordsStreamed = false;
        @Nullable
        private Timestamp firstConsTimeOfCurrentBlock = null;

        public Builder() {
        }

        public Builder(long lastBlockNumber, Timestamp firstConsTimeOfLastBlock, Bytes blockHashes, Timestamp consTimeOfLastHandledTxn, boolean migrationRecordsStreamed, Timestamp firstConsTimeOfCurrentBlock) {
            this.lastBlockNumber = lastBlockNumber;
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            this.blockHashes = blockHashes;
            this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
            this.migrationRecordsStreamed = migrationRecordsStreamed;
            this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
        }

        public BlockInfo build() {
            return new BlockInfo(this.lastBlockNumber, this.firstConsTimeOfLastBlock, this.blockHashes, this.consTimeOfLastHandledTxn, this.migrationRecordsStreamed, this.firstConsTimeOfCurrentBlock);
        }

        public Builder lastBlockNumber(long lastBlockNumber) {
            this.lastBlockNumber = lastBlockNumber;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(@Nullable Timestamp firstConsTimeOfLastBlock) {
            this.firstConsTimeOfLastBlock = firstConsTimeOfLastBlock;
            return this;
        }

        public Builder firstConsTimeOfLastBlock(Timestamp.Builder builder) {
            this.firstConsTimeOfLastBlock = builder.build();
            return this;
        }

        public Builder blockHashes(@NonNull Bytes blockHashes) {
            this.blockHashes = blockHashes != null ? blockHashes : Bytes.EMPTY;
            return this;
        }

        public Builder consTimeOfLastHandledTxn(@Nullable Timestamp consTimeOfLastHandledTxn) {
            this.consTimeOfLastHandledTxn = consTimeOfLastHandledTxn;
            return this;
        }

        public Builder consTimeOfLastHandledTxn(Timestamp.Builder builder) {
            this.consTimeOfLastHandledTxn = builder.build();
            return this;
        }

        public Builder migrationRecordsStreamed(boolean migrationRecordsStreamed) {
            this.migrationRecordsStreamed = migrationRecordsStreamed;
            return this;
        }

        public Builder firstConsTimeOfCurrentBlock(@Nullable Timestamp firstConsTimeOfCurrentBlock) {
            this.firstConsTimeOfCurrentBlock = firstConsTimeOfCurrentBlock;
            return this;
        }

        public Builder firstConsTimeOfCurrentBlock(Timestamp.Builder builder) {
            this.firstConsTimeOfCurrentBlock = builder.build();
            return this;
        }
    }
}

