/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.common;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.common.codec.EntityIDPairJsonCodec;
import com.hedera.hapi.node.state.common.codec.EntityIDPairProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record EntityIDPair(@Nullable AccountID accountId, @Nullable TokenID tokenId) {
    public static final Codec<EntityIDPair> PROTOBUF = new EntityIDPairProtoCodec();
    public static final JsonCodec<EntityIDPair> JSON = new EntityIDPairJsonCodec();
    public static final EntityIDPair DEFAULT = EntityIDPair.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.accountId != null && !this.accountId.equals(EntityIDPair.DEFAULT.accountId)) {
            result = 31 * result + this.accountId.hashCode();
        }
        if (this.tokenId != null && !this.tokenId.equals(EntityIDPair.DEFAULT.tokenId)) {
            result = 31 * result + this.tokenId.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        EntityIDPair thatObj = (EntityIDPair)that;
        if (this.accountId == null && thatObj.accountId != null) {
            return false;
        }
        if (this.accountId != null && !this.accountId.equals(thatObj.accountId)) {
            return false;
        }
        if (this.tokenId == null && thatObj.tokenId != null) {
            return false;
        }
        return this.tokenId == null || this.tokenId.equals(thatObj.tokenId);
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.tokenId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID accountId = null;
        @Nullable
        private TokenID tokenId = null;

        public Builder() {
        }

        public Builder(AccountID accountId, TokenID tokenId) {
            this.accountId = accountId;
            this.tokenId = tokenId;
        }

        public EntityIDPair build() {
            return new EntityIDPair(this.accountId, this.tokenId);
        }

        public Builder accountId(@Nullable AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder tokenId(@Nullable TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }
    }
}

