/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.consensus;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.state.consensus.codec.TopicJsonCodec;
import com.hedera.hapi.node.state.consensus.codec.TopicProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record Topic(@Nullable TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, @Nullable AccountID autoRenewAccountId, boolean deleted, @NonNull Bytes runningHash, String memo, @Nullable Key adminKey, @Nullable Key submitKey) {
    public static final Codec<Topic> PROTOBUF = new TopicProtoCodec();
    public static final JsonCodec<Topic> JSON = new TopicJsonCodec();
    public static final Topic DEFAULT = Topic.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.topicId != null && !this.topicId.equals(Topic.DEFAULT.topicId)) {
            result = 31 * result + this.topicId.hashCode();
        }
        if (this.sequenceNumber != Topic.DEFAULT.sequenceNumber) {
            result = 31 * result + Long.hashCode(this.sequenceNumber);
        }
        if (this.expirationSecond != Topic.DEFAULT.expirationSecond) {
            result = 31 * result + Long.hashCode(this.expirationSecond);
        }
        if (this.autoRenewPeriod != Topic.DEFAULT.autoRenewPeriod) {
            result = 31 * result + Long.hashCode(this.autoRenewPeriod);
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(Topic.DEFAULT.autoRenewAccountId)) {
            result = 31 * result + this.autoRenewAccountId.hashCode();
        }
        if (this.deleted != Topic.DEFAULT.deleted) {
            result = 31 * result + Boolean.hashCode(this.deleted);
        }
        if (this.runningHash != null && !this.runningHash.equals((Object)Topic.DEFAULT.runningHash)) {
            result = 31 * result + this.runningHash.hashCode();
        }
        if (this.memo != null && !this.memo.equals(Topic.DEFAULT.memo)) {
            result = 31 * result + this.memo.hashCode();
        }
        if (this.adminKey != null && !this.adminKey.equals(Topic.DEFAULT.adminKey)) {
            result = 31 * result + this.adminKey.hashCode();
        }
        if (this.submitKey != null && !this.submitKey.equals(Topic.DEFAULT.submitKey)) {
            result = 31 * result + this.submitKey.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        Topic thatObj = (Topic)that;
        if (this.topicId == null && thatObj.topicId != null) {
            return false;
        }
        if (this.topicId != null && !this.topicId.equals(thatObj.topicId)) {
            return false;
        }
        if (this.sequenceNumber != thatObj.sequenceNumber) {
            return false;
        }
        if (this.expirationSecond != thatObj.expirationSecond) {
            return false;
        }
        if (this.autoRenewPeriod != thatObj.autoRenewPeriod) {
            return false;
        }
        if (this.autoRenewAccountId == null && thatObj.autoRenewAccountId != null) {
            return false;
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(thatObj.autoRenewAccountId)) {
            return false;
        }
        if (this.deleted != thatObj.deleted) {
            return false;
        }
        if (this.runningHash == null && thatObj.runningHash != null) {
            return false;
        }
        if (this.runningHash != null && !this.runningHash.equals((Object)thatObj.runningHash)) {
            return false;
        }
        if (this.memo == null && thatObj.memo != null) {
            return false;
        }
        if (this.memo != null && !this.memo.equals(thatObj.memo)) {
            return false;
        }
        if (this.adminKey == null && thatObj.adminKey != null) {
            return false;
        }
        if (this.adminKey != null && !this.adminKey.equals(thatObj.adminKey)) {
            return false;
        }
        if (this.submitKey == null && thatObj.submitKey != null) {
            return false;
        }
        return this.submitKey == null || this.submitKey.equals(thatObj.submitKey);
    }

    public boolean hasTopicId() {
        return this.topicId != null;
    }

    public TopicID topicIdOrElse(@NonNull TopicID defaultValue) {
        return this.hasTopicId() ? this.topicId : defaultValue;
    }

    @NonNull
    public TopicID topicIdOrThrow() {
        return Objects.requireNonNull(this.topicId, "Field topicId is null");
    }

    public void ifTopicId(@NonNull Consumer<TopicID> ifPresent) {
        if (this.hasTopicId()) {
            ifPresent.accept(this.topicId);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasSubmitKey() {
        return this.submitKey != null;
    }

    public Key submitKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSubmitKey() ? this.submitKey : defaultValue;
    }

    @NonNull
    public Key submitKeyOrThrow() {
        return Objects.requireNonNull(this.submitKey, "Field submitKey is null");
    }

    public void ifSubmitKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSubmitKey()) {
            ifPresent.accept(this.submitKey);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private TopicID topicId = null;
        private long sequenceNumber = 0L;
        private long expirationSecond = 0L;
        private long autoRenewPeriod = 0L;
        @Nullable
        private AccountID autoRenewAccountId = null;
        private boolean deleted = false;
        @NonNull
        private Bytes runningHash = Bytes.EMPTY;
        private String memo = "";
        @Nullable
        private Key adminKey = null;
        @Nullable
        private Key submitKey = null;

        public Builder() {
        }

        public Builder(TopicID topicId, long sequenceNumber, long expirationSecond, long autoRenewPeriod, AccountID autoRenewAccountId, boolean deleted, Bytes runningHash, String memo, Key adminKey, Key submitKey) {
            this.topicId = topicId;
            this.sequenceNumber = sequenceNumber;
            this.expirationSecond = expirationSecond;
            this.autoRenewPeriod = autoRenewPeriod;
            this.autoRenewAccountId = autoRenewAccountId;
            this.deleted = deleted;
            this.runningHash = runningHash;
            this.memo = memo;
            this.adminKey = adminKey;
            this.submitKey = submitKey;
        }

        public Topic build() {
            return new Topic(this.topicId, this.sequenceNumber, this.expirationSecond, this.autoRenewPeriod, this.autoRenewAccountId, this.deleted, this.runningHash, this.memo, this.adminKey, this.submitKey);
        }

        public Builder topicId(@Nullable TopicID topicId) {
            this.topicId = topicId;
            return this;
        }

        public Builder topicId(TopicID.Builder builder) {
            this.topicId = builder.build();
            return this;
        }

        public Builder sequenceNumber(long sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder autoRenewPeriod(long autoRenewPeriod) {
            this.autoRenewPeriod = autoRenewPeriod;
            return this;
        }

        public Builder autoRenewAccountId(@Nullable AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder runningHash(@NonNull Bytes runningHash) {
            this.runningHash = runningHash != null ? runningHash : Bytes.EMPTY;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(@Nullable Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder submitKey(@Nullable Key submitKey) {
            this.submitKey = submitKey;
            return this;
        }

        public Builder submitKey(Key.Builder builder) {
            this.submitKey = builder.build();
            return this;
        }
    }
}

