/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.contract.codec.SlotKeyJsonCodec;
import com.hedera.hapi.node.state.contract.codec.SlotKeyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SlotKey(@Nullable ContractID contractID, @NonNull Bytes key) {
    public static final Codec<SlotKey> PROTOBUF = new SlotKeyProtoCodec();
    public static final JsonCodec<SlotKey> JSON = new SlotKeyJsonCodec();
    public static final SlotKey DEFAULT = SlotKey.newBuilder().build();

    @Override
    public int hashCode() {
        int result = 1;
        if (this.contractID != null && !this.contractID.equals(SlotKey.DEFAULT.contractID)) {
            result = 31 * result + this.contractID.hashCode();
        }
        if (this.key != null && !this.key.equals((Object)SlotKey.DEFAULT.key)) {
            result = 31 * result + this.key.hashCode();
        }
        long hashCode = result;
        hashCode += hashCode << 30;
        hashCode ^= hashCode >>> 27;
        hashCode += hashCode << 16;
        hashCode ^= hashCode >>> 20;
        hashCode += hashCode << 5;
        hashCode ^= hashCode >>> 18;
        hashCode += hashCode << 10;
        hashCode ^= hashCode >>> 24;
        hashCode += hashCode << 30;
        return (int)hashCode;
    }

    @Override
    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SlotKey thatObj = (SlotKey)that;
        if (this.contractID == null && thatObj.contractID != null) {
            return false;
        }
        if (this.contractID != null && !this.contractID.equals(thatObj.contractID)) {
            return false;
        }
        if (this.key == null && thatObj.key != null) {
            return false;
        }
        return this.key == null || this.key.equals((Object)thatObj.key);
    }

    public boolean hasContractID() {
        return this.contractID != null;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID, "Field contractID is null");
    }

    public void ifContractID(@NonNull Consumer<ContractID> ifPresent) {
        if (this.hasContractID()) {
            ifPresent.accept(this.contractID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.contractID, this.key);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ContractID contractID = null;
        @NonNull
        private Bytes key = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(ContractID contractID, Bytes key) {
            this.contractID = contractID;
            this.key = key;
        }

        public SlotKey build() {
            return new SlotKey(this.contractID, this.key);
        }

        public Builder contractID(@Nullable ContractID contractID) {
            this.contractID = contractID;
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.contractID = builder.build();
            return this;
        }

        public Builder key(@NonNull Bytes key) {
            this.key = key != null ? key : Bytes.EMPTY;
            return this;
        }
    }
}

